/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl;

import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.bookmark.TransactionBookmarkManagerImpl;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.router.QueryRouter;
import org.neo4j.router.impl.query.CompositeQueryTargetService;
import org.neo4j.router.impl.query.StandardQueryTargetService;
import org.neo4j.router.impl.transaction.RouterTransactionContextImpl;
import org.neo4j.router.impl.transaction.RouterTransactionImpl;
import org.neo4j.router.location.LocationService;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryTargetParser;
import org.neo4j.router.query.QueryTargetService;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.RouterTransactionContext;
import org.neo4j.router.transaction.RoutingInfo;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.time.SystemNanoClock;

public class QueryRouterImpl
implements QueryRouter {
    private final QueryTargetParser queryTargetParser;
    private final DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory;
    private final DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory;
    private final Function<RoutingInfo, LocationService> locationServiceFactory;
    private final Config config;
    private final DatabaseReferenceResolver databaseReferenceResolver;
    private final ErrorReporter errorReporter;
    private final SystemNanoClock systemNanoClock;
    private final LocalGraphTransactionIdTracker transactionIdTracker;

    public QueryRouterImpl(Config config, DatabaseReferenceResolver databaseReferenceResolver, Function<RoutingInfo, LocationService> locationServiceFactory, QueryTargetParser queryTargetParser, DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory, DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory, ErrorReporter errorReporter, SystemNanoClock systemNanoClock, LocalGraphTransactionIdTracker transactionIdTracker) {
        this.config = config;
        this.databaseReferenceResolver = databaseReferenceResolver;
        this.locationServiceFactory = locationServiceFactory;
        this.queryTargetParser = queryTargetParser;
        this.localDatabaseTransactionFactory = localDatabaseTransactionFactory;
        this.remoteDatabaseTransactionFactory = remoteDatabaseTransactionFactory;
        this.errorReporter = errorReporter;
        this.systemNanoClock = systemNanoClock;
        this.transactionIdTracker = transactionIdTracker;
    }

    @Override
    public RouterTransactionContext beginTransaction(TransactionInfo incomingTransactionInfo) {
        TransactionBookmarkManagerImpl transactionBookmarkManager = new TransactionBookmarkManagerImpl(BookmarkFormat.parse(incomingTransactionInfo.bookmarks()));
        transactionBookmarkManager.getBookmarkForLocalSystemDatabase().ifPresent(localBookmark -> this.transactionIdTracker.awaitSystemGraphUpToDate(localBookmark.transactionId()));
        TransactionInfo transactionInfo = incomingTransactionInfo.withDefaults(this.config);
        DatabaseReference sessionDatabaseReference = this.resolveSessionDatabaseReference(transactionInfo);
        RoutingInfo routingInfo = new RoutingInfo(sessionDatabaseReference, transactionInfo.routingContext(), transactionInfo.accessMode());
        QueryTargetService queryTargetService = this.createQueryTargetService(routingInfo);
        LocationService locationService = this.createLocationService(routingInfo);
        RouterTransactionImpl routerTransaction = this.createRouterTransaction(transactionInfo, (TransactionBookmarkManager)transactionBookmarkManager);
        return new RouterTransactionContextImpl(transactionInfo, routingInfo, routerTransaction, queryTargetService, locationService, (TransactionBookmarkManager)transactionBookmarkManager);
    }

    private DatabaseReference resolveSessionDatabaseReference(TransactionInfo transactionInfo) {
        NormalizedDatabaseName sessionDatabaseName = transactionInfo.sessionDatabaseName();
        return this.databaseReferenceResolver.resolve(sessionDatabaseName);
    }

    private QueryTargetService createQueryTargetService(RoutingInfo routingInfo) {
        DatabaseReference sessionDatabaseReference = routingInfo.sessionDatabaseReference();
        if (sessionDatabaseReference.isComposite()) {
            return new CompositeQueryTargetService(sessionDatabaseReference);
        }
        return new StandardQueryTargetService(sessionDatabaseReference, this.queryTargetParser, this.databaseReferenceResolver);
    }

    private LocationService createLocationService(RoutingInfo routingInfo) {
        return this.locationServiceFactory.apply(routingInfo);
    }

    private RouterTransactionImpl createRouterTransaction(TransactionInfo transactionInfo, TransactionBookmarkManager transactionBookmarkManager) {
        return new RouterTransactionImpl(transactionInfo, this.localDatabaseTransactionFactory, this.remoteDatabaseTransactionFactory, this.errorReporter, this.systemNanoClock, transactionBookmarkManager);
    }

    @Override
    public QueryExecution executeQuery(RouterTransactionContext context, Query query, QuerySubscriber subscriber) {
        DatabaseReference target = context.queryTargetService().determineTarget(query);
        Location location = context.locationService().locationOf(target);
        DatabaseTransaction databaseTransaction = context.transactionFor(location);
        return databaseTransaction.executeQuery(query, subscriber);
    }
}

