/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.AdministrationCommand;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.compiler.CypherParsing;
import org.neo4j.cypher.internal.compiler.helpers.SignatureResolver;
import org.neo4j.cypher.internal.evaluator.SimpleInternalExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.AutoExtractedParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.ScopedProcedureSignatureResolver;
import org.neo4j.cypher.internal.frontend.phases.rewriting.cnf.flattenBooleanOperators;
import org.neo4j.cypher.internal.javacompat.InternalQueryExecutionEngine;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.preparser.QueryOptions;
import org.neo4j.cypher.internal.rewriting.rewriters.RemoveUseRewriter;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.cypher.rendering.QueryOptionsRenderer;
import org.neo4j.cypher.rendering.QueryRenderer;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.executor.Location;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.router.QueryRouterException;
import org.neo4j.router.impl.query.ProcessedQueryInfoCache;
import org.neo4j.router.impl.query.QueryTarget;
import org.neo4j.router.impl.query.StatementType;
import org.neo4j.router.impl.query.StaticUseEvaluation;
import org.neo4j.router.location.LocationService;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryProcessor;
import org.neo4j.router.query.TargetService;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import scala.Option;
import scala.Some$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class QueryProcessorImpl
implements QueryProcessor {
    public static final CatalogName SYSTEM_DATABASE_CATALOG_NAME = CatalogName.of((String)"system", (boolean)true);
    private final ProcessedQueryInfoCache cache;
    private final PreParser preParser;
    private final CypherParsing parsing;
    private final CompilationTracer tracer;
    private final GlobalProcedures globalProcedures;
    private final DatabaseContextProvider<?> databaseContextProvider;
    private final StaticUseEvaluation staticUseEvaluation = new StaticUseEvaluation();

    public QueryProcessorImpl(ProcessedQueryInfoCache cache, PreParser preParser, CypherParsing parsing, CompilationTracer tracer, GlobalProcedures globalProcedures, DatabaseContextProvider<?> databaseContextProvider) {
        this.cache = cache;
        this.preParser = preParser;
        this.parsing = parsing;
        this.tracer = tracer;
        this.globalProcedures = globalProcedures;
        this.databaseContextProvider = databaseContextProvider;
    }

    @Override
    public PreParsedQuery preParse(Query query, CypherVersion defaultLanguage) {
        return this.preParser.preParse(query.text(), defaultLanguage);
    }

    @Override
    public QueryProcessor.ProcessedQueryInfo processQuery(Query query, PreParsedQuery preParsedQuery, TargetService targetService, LocationService locationService, CancellationChecker cancellationChecker, DatabaseReference sessionDatabase) {
        ProcessedQueryInfoCache.Value cachedValue = this.getFromCache(query, preParsedQuery, cancellationChecker, sessionDatabase);
        QueryTarget queryTarget = targetService.target(cachedValue.catalogInfo());
        this.maybePutInTargetDatabaseCache(locationService, queryTarget.reference(), query, cachedValue.preParsedQuery(), cachedValue.parsedQuery(), cachedValue.parsingNotifications());
        Query rewrittenQuery = query;
        if (QueryProcessorImpl.shouldRewriteQuery(queryTarget.reference()).booleanValue()) {
            rewrittenQuery = Query.of(cachedValue.rewrittenQueryText(), query.parameters().updatedWith(cachedValue.maybeExtractedParams()));
        }
        return new QueryProcessor.ProcessedQueryInfo(queryTarget.reference(), rewrittenQuery, OptionConverters.toJava((Option)cachedValue.parsedQuery().maybeObfuscationMetadata()), cachedValue.statementType(), cachedValue.preParsedQuery().options(), cachedValue.parsingNotifications(), queryTarget.routingNotifications());
    }

    @Override
    public long clearQueryCachesForDatabase(String databaseName) {
        return this.cache.clearQueryCachesForDatabase(databaseName);
    }

    @Override
    public DatabaseContextProvider<?> databaseContextProvider() {
        return this.databaseContextProvider;
    }

    private ProcessedQueryInfoCache.Value getFromCache(Query query, PreParsedQuery preParsedQuery, CancellationChecker cancellationChecker, DatabaseReference sessionDatabase) {
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        ProcessedQueryInfoCache.Value cachedValue = this.cache.get(preParsedQuery, query.parameters());
        if (cachedValue == null) {
            ProcessedQueryInfoCache.Value preparedForCacheQuery = this.prepareQueryForCache(preParsedQuery, notificationLogger, query, cancellationChecker, sessionDatabase);
            if (preparedForCacheQuery.catalogInfo().canBeCached()) {
                this.cache.put(preParsedQuery, query.parameters(), preparedForCacheQuery);
            }
            cachedValue = preparedForCacheQuery;
        }
        return cachedValue;
    }

    private ProcessedQueryInfoCache.Value prepareQueryForCache(PreParsedQuery preParsedQuery, RecordingNotificationLogger notificationLogger, Query query, CancellationChecker cancellationChecker, DatabaseReference sessionDatabase) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer.compileQuery(query.text());
        ScopedProcedureSignatureResolver resolver = SignatureResolver.from((ProcedureView)this.globalProcedures.getCurrentView(), (CypherVersion)preParsedQuery.resolvedLanguage());
        BaseState parsedQuery = this.parse(query, queryTracer, preParsedQuery, resolver, notificationLogger, cancellationChecker, sessionDatabase);
        TargetService.CatalogInfo catalogInfo = this.resolveCatalogInfo(parsedQuery.statement(), sessionDatabase.isComposite(), this.databaseContextProvider.databaseIdRepository(), query);
        String rewrittenQueryText = QueryProcessorImpl.rewriteQueryText(parsedQuery, preParsedQuery.options(), cancellationChecker);
        MapValue maybeExtractedParams = QueryProcessorImpl.formatMaybeExtractedParams(parsedQuery);
        StatementType statementType = StatementType.of(parsedQuery.statement(), resolver);
        java.util.Set parsingNotifications = CollectionConverters.asJava((Set)notificationLogger.notifications());
        return new ProcessedQueryInfoCache.Value(catalogInfo, rewrittenQueryText, maybeExtractedParams, preParsedQuery, parsedQuery, statementType, parsingNotifications);
    }

    private TargetService.CatalogInfo resolveCatalogInfo(Statement statement, boolean targetsComposite, DatabaseIdRepository databaseIdRepository, Query query) {
        if (statement instanceof AdministrationCommand) {
            return new TargetService.SingleQueryCatalogInfo(Optional.of(SYSTEM_DATABASE_CATALOG_NAME), true);
        }
        if (targetsComposite) {
            return new TargetService.CompositeCatalogInfo();
        }
        Seq<Option<StaticUseEvaluation.CatalogInfo>> graphSelections = this.staticUseEvaluation.evaluateStaticTopQueriesGraphSelections(statement, databaseIdRepository, query.parameters());
        return this.toCatalogInfo(graphSelections);
    }

    private static String rewriteQueryText(BaseState parsedQuery, QueryOptions queryOptions, CancellationChecker cancellationChecker) {
        Object rewrittenStatement = flattenBooleanOperators.instance((CancellationChecker)cancellationChecker).apply(RemoveUseRewriter.instance().apply((Object)parsedQuery.statement()));
        String rewrittenStatementString = QueryRenderer.render((Statement)((Statement)rewrittenStatement));
        return QueryOptionsRenderer.addOptions((String)rewrittenStatementString, (QueryOptions)queryOptions.withQueryLanguage(queryOptions.resolvedLanguage()));
    }

    private static MapValue formatMaybeExtractedParams(BaseState parsedQuery) {
        MapValueBuilder mapValueBuilder = new MapValueBuilder();
        Map extractedParams = (Map)parsedQuery.maybeExtractedParams().get();
        if (extractedParams.nonEmpty()) {
            SimpleInternalExpressionEvaluator evaluator = new SimpleInternalExpressionEvaluator();
            extractedParams.foreach(param -> mapValueBuilder.add(((AutoExtractedParameter)param._1).name(), evaluator.evaluate((Expression)param._2, MapValue.EMPTY, CypherRow.empty())));
        }
        return mapValueBuilder.build();
    }

    private static Boolean shouldRewriteQuery(DatabaseReference databaseReference) {
        return databaseReference instanceof DatabaseReferenceImpl.External;
    }

    private void maybePutInTargetDatabaseCache(LocationService locationService, DatabaseReference databaseReference, Query query, PreParsedQuery preParsedQuery, BaseState parsedQuery, java.util.Set<InternalNotification> parsingNotifications) {
        Location.Local localLocation;
        Location location;
        try {
            location = locationService.locationOf(databaseReference);
        }
        catch (Exception e) {
            return;
        }
        if (location instanceof Location.Local && !(localLocation = (Location.Local)location).getDatabaseName().equals("system")) {
            DatabaseContext databaseContext = (DatabaseContext)this.databaseContextProvider.getDatabaseContext(localLocation.databaseReference().databaseId()).orElseThrow(QueryProcessorImpl.databaseNotFound(localLocation.getDatabaseName()));
            this.checkDatabaseAvailable(databaseContext);
            DependencyResolver resolver = databaseContext.dependencies();
            InternalQueryExecutionEngine queryExecutionEngine = (InternalQueryExecutionEngine)resolver.resolveDependency(InternalQueryExecutionEngine.class);
            queryExecutionEngine.insertIntoCache(query.text(), preParsedQuery, query.parameters(), parsedQuery, parsingNotifications);
        }
    }

    private void checkDatabaseAvailable(DatabaseContext databaseContext) {
        try {
            databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        }
        catch (UnavailableException e) {
            throw new QueryRouterException(e.status(), e);
        }
    }

    private BaseState parse(Query query, CompilationTracer.QueryCompilationEvent queryTracer, PreParsedQuery preParsedQuery, ScopedProcedureSignatureResolver resolver, RecordingNotificationLogger notificationLogger, CancellationChecker cancellationChecker, DatabaseReference sessionDatabase) {
        return this.parsing.parseQuery(preParsedQuery.statement(), preParsedQuery.rawStatement(), preParsedQuery.resolvedLanguage(), (InternalNotificationLogger)notificationLogger, preParsedQuery.options().queryOptions().planner().name(), Option.apply((Object)preParsedQuery.options().offset()), (CompilationPhaseTracer)queryTracer, query.parameters(), cancellationChecker, (Option)Some$.MODULE$.apply((Object)resolver), sessionDatabase);
    }

    private TargetService.CatalogInfo toCatalogInfo(Seq<Option<StaticUseEvaluation.CatalogInfo>> graphSelections) {
        if (graphSelections.size() == 1) {
            Option catalogInfo = (Option)graphSelections.head();
            boolean canBeCached = catalogInfo.isEmpty() || ((StaticUseEvaluation.CatalogInfo)catalogInfo.get()).canBeCached();
            Optional<CatalogName> catalogName = OptionConverters.toJava((Option)catalogInfo).map(info -> info.catalogName());
            return new TargetService.SingleQueryCatalogInfo(catalogName, canBeCached);
        }
        boolean[] canBeCached = new boolean[]{true};
        List<Optional<CatalogName>> catalogNames = CollectionConverters.asJava(graphSelections).stream().map(OptionConverters::toJava).map(catalogInfoOption -> catalogInfoOption.map(catalogInfo -> {
            if (!catalogInfo.canBeCached()) {
                canBeCached[0] = false;
            }
            return catalogInfo.catalogName();
        })).toList();
        return new TargetService.UnionQueryCatalogInfo(catalogNames, canBeCached[0]);
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> DatabaseNotFoundHelper.databaseNameNotFoundWithoutDot((String)databaseNameRaw);
    }
}

