/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.fabric.transaction.parent.CompoundTransaction;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.router.QueryRouterException;
import org.neo4j.router.impl.query.StatementType;
import org.neo4j.router.impl.transaction.RouterTransactionManager;
import org.neo4j.router.impl.transaction.database.LocalDatabaseTransaction;
import org.neo4j.router.location.LocationService;
import org.neo4j.router.query.Query;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.RouterTransaction;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.time.SystemNanoClock;

public class RouterTransactionImpl
implements CompoundTransaction<DatabaseTransaction>,
RouterTransaction {
    private final TransactionInfo transactionInfo;
    private final DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory;
    private final DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory;
    private final TransactionBookmarkManager transactionBookmarkManager;
    private final Map<UUID, DatabaseTransaction> databaseTransactions;
    private final TransactionInitializationTrace initializationTrace;
    private final RouterTransactionManager transactionManager;
    private final SystemNanoClock clock;
    private final ErrorReporter errorReporter;
    private ConstituentTransactionFactory constituentTransactionFactory;
    private final Set<ReadingChildTransaction> readingTransactions = new CopyOnWriteArraySet<ReadingChildTransaction>();
    private volatile DatabaseTransaction writingTransaction;
    private final AtomicReference<State> state = new AtomicReference<State>(State.OPEN);
    private volatile TerminationMark terminationMark;
    private volatile StatementType statementType = null;

    public RouterTransactionImpl(TransactionInfo transactionInfo, DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory, DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory, ErrorReporter errorReporter, SystemNanoClock clock, TransactionBookmarkManager transactionBookmarkManager, TraceProvider traceProvider, RouterTransactionManager transactionManager) {
        this.transactionInfo = transactionInfo;
        this.localDatabaseTransactionFactory = localDatabaseTransactionFactory;
        this.remoteDatabaseTransactionFactory = remoteDatabaseTransactionFactory;
        this.transactionBookmarkManager = transactionBookmarkManager;
        this.initializationTrace = traceProvider.getTraceInfo();
        this.transactionManager = transactionManager;
        this.clock = clock;
        this.errorReporter = errorReporter;
        this.databaseTransactions = new HashMap<UUID, DatabaseTransaction>();
    }

    @Override
    public DatabaseTransaction transactionFor(Location location, TransactionMode mode, LocationService locationService) {
        DatabaseTransaction tx = this.databaseTransactions.computeIfAbsent(location.databaseReference().id(), ref -> this.registerNewChildTransaction(location, mode, () -> this.createTransactionFor(location, locationService)));
        if (mode == TransactionMode.DEFINITELY_WRITE) {
            this.upgradeToWritingTransaction(tx);
        }
        return tx;
    }

    @Override
    public void setConstituentTransactionFactory(ConstituentTransactionFactory constituentTransactionFactory) {
        this.constituentTransactionFactory = constituentTransactionFactory;
    }

    private DatabaseTransaction createTransactionFor(Location location, LocationService locationService) {
        if (location instanceof Location.Local) {
            Location.Local local = (Location.Local)location;
            return this.localDatabaseTransactionFactory.beginTransaction(local, this.transactionInfo, this.transactionBookmarkManager, this::childTransactionTerminated, this.constituentTransactionFactory);
        }
        if (location instanceof Location.Remote) {
            Location.Remote remote = (Location.Remote)location;
            return this.remoteDatabaseTransactionFactory.beginTransaction(remote, this.transactionInfo, this.transactionBookmarkManager, this::childTransactionTerminated, this.constituentTransactionFactory);
        }
        throw new IllegalArgumentException("Unexpected Location type: " + String.valueOf(location));
    }

    public Optional<TerminationMark> getTerminationMark() {
        return Optional.ofNullable(this.terminationMark);
    }

    @Override
    public Optional<Status> getReasonIfTerminated() {
        return this.getTerminationMark().map(TerminationMark::getReason);
    }

    @Override
    public void verifyStatementType(Query query, StatementType type) {
        if (this.statementType == null) {
            this.statementType = type;
        } else {
            StatementType oldType = this.statementType;
            if (!oldType.equals(type)) {
                boolean allowedCombination;
                boolean sameStatementType = type.statementType().equals((Object)oldType.statementType());
                boolean readQueryAfterSchema = type.isReadQuery() && oldType.isSchemaCommand();
                boolean schemaAfterReadQuery = type.isSchemaCommand() && oldType.isReadQuery();
                boolean bl = allowedCombination = readQueryAfterSchema || schemaAfterReadQuery || sameStatementType;
                if (allowedCombination) {
                    boolean upgrade;
                    boolean queryAfterQuery = type.isQuery() && oldType.isQuery();
                    boolean writeQueryAfterReadQuery = queryAfterQuery && !type.isReadQuery() && oldType.isReadQuery();
                    boolean bl2 = upgrade = writeQueryAfterReadQuery || schemaAfterReadQuery;
                    if (upgrade) {
                        this.statementType = type;
                    }
                } else {
                    int maxLength = 40;
                    String queryText = query.text().length() > maxLength ? query.text().substring(0, maxLength - 3) + "..." : query.text();
                    throw QueryRouterException.invalidCombinationOfStatementTypes(queryText, String.format("Tried to execute %s after executing %s", type, oldType));
                }
            }
        }
    }

    boolean isSchemaTransaction() {
        StatementType type = this.statementType;
        return type != null && type.isSchemaCommand();
    }

    TransactionInfo transactionInfo() {
        return this.transactionInfo;
    }

    TransactionInitializationTrace initializationTrace() {
        return this.initializationTrace;
    }

    public void commit() {
        if (!this.state.compareAndSet(State.OPEN, State.CLOSED)) {
            if (this.state.get() == State.TERMINATED) {
                this.doRollbackAndIgnoreErrors();
                throw new TransactionTerminatedException(this.terminationMark.getReason());
            }
            if (this.state.get() == State.CLOSED) {
                throw new QueryRouterException((Status)Status.Transaction.TransactionCommitFailed, "Trying to commit closed transaction", new Object[0]);
            }
        }
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        this.doOnChildren(this.readingTransactions, null, allFailures, DatabaseTransaction::commit, ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN02).build(), () -> "Failed to commit a child read transaction");
        if (!allFailures.isEmpty()) {
            this.doOnChildren(Set.of(), this.writingTransaction, allFailures, DatabaseTransaction::rollback, ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N02).build(), () -> "Failed to rollback a child write transaction");
        } else {
            this.doOnChildren(Set.of(), this.writingTransaction, allFailures, DatabaseTransaction::commit, ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN02).build(), () -> "Failed to commit a child write transaction");
        }
        this.closeContextsAndRemoveTransaction();
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionCommitFailed);
    }

    public void rollback() {
        if (!this.state.compareAndSet(State.OPEN, State.CLOSED)) {
            if (this.state.get() == State.TERMINATED) {
                this.doRollbackAndIgnoreErrors();
                return;
            }
            if (this.state.get() == State.CLOSED) {
                return;
            }
        }
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        this.doOnChildren(this.readingTransactions, this.writingTransaction, allFailures, DatabaseTransaction::rollback, ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N02).build(), () -> "Failed to rollback a child transaction");
        this.closeContextsAndRemoveTransaction();
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionRollbackFailed);
    }

    private void doRollbackAndIgnoreErrors() {
        try {
            this.doOnChildren(this.readingTransactions, this.writingTransaction, new ArrayList<ErrorRecord>(), DatabaseTransaction::rollback, null, () -> "");
        }
        finally {
            this.closeContextsAndRemoveTransaction();
        }
    }

    public boolean markForTermination(Status reason) {
        if (!this.state.compareAndSet(State.OPEN, State.TERMINATED)) {
            return false;
        }
        this.terminationMark = new TerminationMark(reason, this.clock.nanos());
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        this.doOnChildren(this.readingTransactions, this.writingTransaction, allFailures, tx -> tx.terminate(reason), ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN04).build(), () -> "Failed to terminate a child transaction");
        this.throwIfNonEmpty(allFailures, (Status)Status.Transaction.TransactionTerminationFailed);
        return true;
    }

    private void doOnChildren(Set<ReadingChildTransaction> readingTransactions, DatabaseTransaction writingTransaction, List<ErrorRecord> errors, Consumer<DatabaseTransaction> operation, ErrorGqlStatusObject gqlStatusObject, Supplier<String> errorMessage) {
        for (ReadingChildTransaction readingTransaction : readingTransactions) {
            try {
                operation.accept(readingTransaction.inner);
            }
            catch (RuntimeException e) {
                errors.add(new ErrorRecord(gqlStatusObject, errorMessage.get(), e));
            }
        }
        try {
            if (writingTransaction != null) {
                operation.accept(writingTransaction);
            }
        }
        catch (RuntimeException e) {
            errors.add(new ErrorRecord(gqlStatusObject, errorMessage.get(), e));
        }
    }

    public <Tx extends DatabaseTransaction> Tx registerNewChildTransaction(Location location, TransactionMode mode, Supplier<Tx> transactionSupplier) {
        return (Tx)(switch (mode) {
            default -> throw new MatchException(null, null);
            case TransactionMode.DEFINITELY_WRITE -> (DatabaseTransaction)this.startWritingTransaction(location, transactionSupplier);
            case TransactionMode.MAYBE_WRITE -> (DatabaseTransaction)this.startReadingTransaction(false, transactionSupplier);
            case TransactionMode.DEFINITELY_READ -> (DatabaseTransaction)this.startReadingTransaction(true, transactionSupplier);
        });
    }

    private <Tx extends DatabaseTransaction> Tx startWritingTransaction(Location location, Supplier<Tx> writeTransactionSupplier) {
        DatabaseTransaction tx;
        this.checkTransactionOpenForStatementExecution();
        if (this.writingTransaction != null) {
            throw this.multipleWriteError(location, this.writingTransaction.location());
        }
        this.writingTransaction = tx = (DatabaseTransaction)writeTransactionSupplier.get();
        if (this.terminationMark != null) {
            tx.terminate(this.terminationMark.getReason());
        }
        return (Tx)tx;
    }

    private <TX extends DatabaseTransaction> TX startReadingTransaction(boolean readOnly, Supplier<TX> readingTransactionSupplier) {
        this.checkTransactionOpenForStatementExecution();
        DatabaseTransaction tx = (DatabaseTransaction)readingTransactionSupplier.get();
        this.readingTransactions.add(new ReadingChildTransaction(tx, readOnly));
        if (this.terminationMark != null) {
            tx.terminate(this.terminationMark.getReason());
        }
        return (TX)tx;
    }

    public <Tx extends DatabaseTransaction> void upgradeToWritingTransaction(Tx childTransaction) {
        if (this.writingTransaction == childTransaction) {
            return;
        }
        if (this.writingTransaction != null) {
            throw this.multipleWriteError(childTransaction.location(), this.writingTransaction.location());
        }
        ReadingChildTransaction readingTransaction = this.readingTransactions.stream().filter(readingTx -> readingTx.inner == childTransaction).findAny().orElseThrow(() -> new IllegalArgumentException("The supplied transaction has not been registered"));
        if (readingTransaction.readingOnly) {
            throw new IllegalStateException("Upgrading reading-only transaction to a writing one is not allowed");
        }
        this.readingTransactions.remove(readingTransaction);
        this.writingTransaction = readingTransaction.inner;
        if (this.terminationMark != null) {
            this.writingTransaction.terminate(this.terminationMark.getReason());
        }
    }

    public void registerAutocommitQuery(CompoundTransaction.AutocommitQuery autocommitQuery) {
        throw new IllegalStateException("Autocommit queries are not supported by Query Router transaction");
    }

    public void unRegisterAutocommitQuery(CompoundTransaction.AutocommitQuery autocommitQuery) {
        throw new IllegalStateException("Autocommit queries are not supported by Query Router transaction");
    }

    public void childTransactionTerminated(Status reason) {
        this.markForTermination(reason);
    }

    public void closeTransaction(DatabaseTransaction databaseTransaction) {
        if (this.readingTransactions.removeIf(readingTx -> readingTx.inner == databaseTransaction)) {
            databaseTransaction.close();
        }
    }

    private void throwIfNonEmpty(List<ErrorRecord> failures, Status defaultStatusCode) {
        if (!failures.isEmpty()) {
            RuntimeException mainException = this.transform(failures.get((int)0).gqlStatusObject, defaultStatusCode, failures.get((int)0).error);
            for (int i = 1; i < failures.size(); ++i) {
                ErrorRecord errorRecord = failures.get(i);
                mainException.addSuppressed(errorRecord.error);
                this.errorReporter.report(errorRecord.message, errorRecord.error, defaultStatusCode);
            }
            throw mainException;
        }
    }

    private void closeContextsAndRemoveTransaction() {
        this.databaseTransactions.values().forEach(DatabaseTransaction::close);
        this.transactionManager.unregisterTransaction(this);
    }

    private QueryRouterException multipleWriteError(Location attempt, Location current) {
        if (current.getUuid().equals(attempt.getUuid())) {
            return QueryRouterException.writeDuringLeaderSwitch(attempt, current);
        }
        return new QueryRouterException((Status)Status.Statement.AccessMode, "Writing to more than one database per transaction is not allowed. Attempted write to %s, currently writing to %s", attempt.databaseReference().toPrettyString(), current.databaseReference().toPrettyString());
    }

    private void checkTransactionOpenForStatementExecution() {
        this.throwIfTerminatedOrClosed(() -> "Trying to execute query in a closed transaction");
    }

    @Override
    public void throwIfTerminatedOrClosed(Supplier<String> closedExceptionMessage) {
        if (this.terminationMark != null) {
            throw new TransactionTerminatedException(this.terminationMark.getReason());
        }
        if (this.state.get() == State.CLOSED) {
            throw QueryRouterException.executeQueryInClosedTransaction(closedExceptionMessage.get());
        }
    }

    private RuntimeException transform(ErrorGqlStatusObject fallbackGqlStatusObject, Status defaultStatus, Throwable t) {
        String message = t.getMessage();
        if (t instanceof Status.HasStatus) {
            if (t instanceof RuntimeException) {
                return (RuntimeException)t;
            }
            if (t instanceof ErrorGqlStatusObject) {
                ErrorGqlStatusObject gqlStatusObjectOfT = (ErrorGqlStatusObject)t;
                return new QueryRouterException(gqlStatusObjectOfT, ((Status.HasStatus)t).status(), message, t);
            }
            return new QueryRouterException(((Status.HasStatus)t).status(), message, t);
        }
        return new QueryRouterException(fallbackGqlStatusObject, defaultStatus, message, t);
    }

    Set<InternalTransaction> getInternalTransactions() {
        DatabaseTransaction databaseTransaction;
        HashSet<InternalTransaction> internalTransactions = new HashSet<InternalTransaction>();
        this.readingTransactions.stream().map(ReadingChildTransaction::inner).filter(tx -> tx instanceof LocalDatabaseTransaction).map(LocalDatabaseTransaction.class::cast).map(LocalDatabaseTransaction::internalTransaction).forEach(internalTransactions::add);
        if (this.writingTransaction != null && (databaseTransaction = this.writingTransaction) instanceof LocalDatabaseTransaction) {
            LocalDatabaseTransaction localDatabaseTransaction = (LocalDatabaseTransaction)databaseTransaction;
            internalTransactions.add(localDatabaseTransaction.internalTransaction());
        }
        return internalTransactions;
    }

    void stopRemoteDbsAfterTimeout(long timeoutMillis) {
        List<DatabaseTransaction> nonLocalTransaction = this.readingTransactions.stream().map(ReadingChildTransaction::inner).filter(tx -> !(tx instanceof LocalDatabaseTransaction)).toList();
        if (nonLocalTransaction.isEmpty()) {
            return;
        }
        this.awaitTransactionsClosedWithinTimeout(nonLocalTransaction, timeoutMillis);
        nonLocalTransaction.forEach(tx -> tx.terminate((Status)Status.Transaction.Terminated));
    }

    private void awaitTransactionsClosedWithinTimeout(Collection<DatabaseTransaction> nonLocalTransaction, long timeoutMillis) {
        long deadline = this.clock.millis() + timeoutMillis;
        while (RouterTransactionImpl.hasOpenTransactions(nonLocalTransaction) && this.clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private static boolean hasOpenTransactions(Collection<DatabaseTransaction> nonLocalTransaction) {
        for (DatabaseTransaction dbTransaction : nonLocalTransaction) {
            if (!dbTransaction.isOpen()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMetaData(Map<String, Object> txMeta) {
        this.transactionInfo.setTxMetadata(txMeta);
        this.getInternalTransactions().forEach(tx -> tx.setMetaData(txMeta));
    }

    private static enum State {
        OPEN,
        CLOSED,
        TERMINATED;

    }

    private record ReadingChildTransaction(DatabaseTransaction inner, boolean readingOnly) {
    }

    private record ErrorRecord(ErrorGqlStatusObject gqlStatusObject, String message, Throwable error) {
    }
}

