/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.ProgressTrackingOutputStream;
import org.neo4j.export.UploadCommand;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class HttpCopier
implements UploadCommand.Copier {
    static final int HTTP_RESUME_INCOMPLETE = 308;
    static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    static final int HTTP_TOO_MANY_REQUESTS = 429;
    static final String ERROR_REASON_UNSUPPORTED_INDEXES = "LegacyIndexes";
    static final String ERROR_REASON_EXCEEDS_MAX_SIZE = "ImportExceedsMaxSize";
    private static final long POSITION_UPLOAD_COMPLETED = -1L;
    private static final long DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS = TimeUnit.SECONDS.toMillis(64L);
    private static final long DEFAULT_MAXIMUM_RETRIES = 50L;
    private final ExecutionContext ctx;
    private final Sleeper sleeper;
    private final ProgressListenerFactory progressListenerFactory;
    private final SystemNanoClock clock;
    private final long maxResumeUploadRetries;
    private final long maximumBackoff;

    HttpCopier(ExecutionContext ctx) {
        this(ctx, Thread::sleep, (text, length) -> ProgressMonitorFactory.textual((OutputStream)ctx.out()).singlePart(text, length), Clocks.nanoClock(), 50L, DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS);
    }

    HttpCopier(ExecutionContext ctx, SystemNanoClock clock) {
        this(ctx, Thread::sleep, (text, length) -> ProgressMonitorFactory.textual((OutputStream)ctx.out()).singlePart(text, length), clock, 50L, DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS);
    }

    HttpCopier(ExecutionContext ctx, long maximumRetries, long maximumBackoff) {
        this(ctx, Thread::sleep, (text, length) -> ProgressMonitorFactory.textual((OutputStream)ctx.out()).singlePart(text, length), Clocks.nanoClock(), maximumRetries, maximumBackoff);
    }

    HttpCopier(ExecutionContext ctx, Sleeper sleeper, ProgressListenerFactory progressListenerFactory) {
        this(ctx, sleeper, progressListenerFactory, Clocks.nanoClock(), 50L, DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS);
    }

    HttpCopier(ExecutionContext ctx, Sleeper sleeper, ProgressListenerFactory progressListenerFactory, SystemNanoClock clock, long maxResumeUploadRetries, long maximumBackoff) {
        this.ctx = ctx;
        this.sleeper = sleeper;
        this.progressListenerFactory = progressListenerFactory;
        this.clock = clock;
        this.maxResumeUploadRetries = maxResumeUploadRetries;
        this.maximumBackoff = maximumBackoff;
    }

    private static void safeSkip(InputStream sourceStream, long position) throws IOException {
        for (long toSkip = position; toSkip > 0L; toSkip -= sourceStream.skip(position)) {
        }
    }

    private static long parseResumablePosition(String range) {
        int dashIndex = range.indexOf(45);
        if (!range.startsWith("bytes=") || dashIndex == -1) {
            throw new CommandFailedException("Unexpected response when asking where to resume upload from. got '" + range + "'");
        }
        return Long.parseLong(range.substring(dashIndex + 1)) + 1L;
    }

    private static String base64Encode(String username, char[] password) {
        String plainToken = username + ":" + String.valueOf(password);
        return Base64.getEncoder().encodeToString(plainToken.getBytes());
    }

    private static URL safeUrl(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL '" + urlString + "'", e);
        }
    }

    private static <T> T parseJsonUsingJacksonParser(String json, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(json, type);
    }

    @Override
    public void copy(boolean verbose, String consoleURL, String boltUri, UploadCommand.Source source, boolean deleteSourceAfterImport, String bearerToken) {
        try {
            String bearerTokenHeader = "Bearer " + bearerToken;
            long crc32Sum = source.crc32Sum();
            URL signedURL = this.retryOnUnavailable(() -> this.initiateCopy(verbose, HttpCopier.safeUrl(consoleURL + "/import"), crc32Sum, source.size(), bearerTokenHeader));
            URL uploadLocation = this.retryOnUnavailable(() -> this.initiateResumableUpload(verbose, signedURL));
            long sourceLength = this.ctx.fs().getFileSize(source.path());
            long position = 0L;
            int resumeUploadRetries = 0;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            ProgressTrackingOutputStream.Progress uploadProgress = new ProgressTrackingOutputStream.Progress(this.progressListenerFactory.create("Upload", sourceLength), position);
            while (!this.resumeUpload(verbose, source.path(), boltUri, sourceLength, position, uploadLocation, uploadProgress) && (position = this.getResumablePosition(verbose, sourceLength, uploadLocation)) != -1L) {
                if ((long)resumeUploadRetries > this.maxResumeUploadRetries) {
                    throw new CommandFailedException("Upload failed after numerous attempts.");
                }
                long backoffFromRetryCount = TimeUnit.SECONDS.toMillis(1 << resumeUploadRetries++) + (long)random.nextInt(1000);
                this.sleeper.sleep(Long.min(backoffFromRetryCount, this.maximumBackoff));
            }
            uploadProgress.done();
            this.triggerImportProtocol(verbose, HttpCopier.safeUrl(consoleURL + "/import/upload-complete"), boltUri, source.path(), crc32Sum, bearerTokenHeader);
            this.doStatusPolling(verbose, consoleURL, bearerToken, sourceLength);
            if (deleteSourceAfterImport) {
                Files.delete(source.path());
            } else {
                this.ctx.out().printf("It is safe to delete the dump file now: %s%n", source.path().toAbsolutePath());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void checkSize(boolean verbose, String consoleURL, long size, String bearerToken) {
        this.retryOnUnavailable(() -> {
            this.doCheckSize(verbose, consoleURL, size, bearerToken);
            return null;
        });
    }

    <T> T retryOnUnavailable(IOExceptionSupplier<T> runnableCommand) {
        int attempt = 0;
        Throwable lastException = null;
        while (true) {
            try {
                return runnableCommand.get();
            }
            catch (RetryableHttpException e) {
                if ((long)attempt >= this.maxResumeUploadRetries) break;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                long backoffFromRetryCount = TimeUnit.SECONDS.toMillis(1 << attempt++) + (long)random.nextInt(1000);
                try {
                    this.sleeper.sleep(Long.min(backoffFromRetryCount, this.maximumBackoff));
                }
                catch (InterruptedException ex) {
                    throw new CommandFailedException(e.getMessage(), (Throwable)e);
                }
                lastException = e;
                continue;
            }
            catch (IOException e) {
                throw new CommandFailedException(e.getMessage(), (Throwable)e);
            }
            break;
        }
        throw (RuntimeException)lastException.getCause();
    }

    private void doCheckSize(boolean verbose, String consoleURL, long size, String bearerToken) throws IOException {
        URL url = HttpCopier.safeUrl(consoleURL + "/import/size");
        String bearerTokenHeader = "Bearer " + bearerToken;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", bearerTokenHeader);
            connection.setRequestProperty("Content-Type", "application/json");
            try (OutputStream postData = connection.getOutputStream();){
                postData.write(String.format("{\"FullSize\":%d}", size).getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 422: {
                    throw this.validationFailureErrorResponse(verbose, connection, size);
                }
                case 200: {
                    return;
                }
                case 502: 
                case 503: 
                case 504: {
                    throw new RetryableHttpException(this.unexpectedResponse(verbose, connection, "Size check"));
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Size check");
        }
    }

    private void throwIfImportDidNotStart(long importStartedTimeout) {
        boolean passedStartImportTimeout;
        boolean bl = passedStartImportTimeout = this.clock.millis() > importStartedTimeout;
        if (passedStartImportTimeout) {
            throw new CommandFailedException("Timed out waiting for database load to start as the database did not enter 'loading' state in time. Please retry the operation. You might find more information about the failure on the database status page in https://console.neo4j.io.");
        }
    }

    private void doStatusPolling(boolean verbose, String consoleURL, String bearerToken, long fileSize) throws InterruptedException {
        this.ctx.out().println("We have received your export and it is currently being loaded into your Aura instance.");
        this.ctx.out().println("You can wait here, or abort this command and head over to the console to be notified of when your database is running.");
        String bearerTokenHeader = "Bearer " + bearerToken;
        ProgressTrackingOutputStream.Progress statusProgress = new ProgressTrackingOutputStream.Progress(this.progressListenerFactory.create("Import progress (estimated)", 100L), 0L);
        boolean importHasStarted = false;
        long importStarted = this.clock.millis();
        double importTimeEstimateMinutes = 5.0 + 3.0 * UploadCommand.bytesToGibibytes(fileSize);
        long importTimeEstimateMillis = TimeUnit.SECONDS.toMillis((long)(importTimeEstimateMinutes * 60.0));
        long importStartedTimeout = importStarted + 90000L;
        this.debug(verbose, String.format("Rough guess for how long dump file import will take: %.0f minutes; file size is %.1f GB (%d bytes)", importTimeEstimateMinutes, UploadCommand.bytesToGibibytes(fileSize), fileSize));
        while (!statusProgress.isDone()) {
            StatusBody statusBody = this.getDatabaseStatus(verbose, HttpCopier.safeUrl(consoleURL + "/import/status"), bearerTokenHeader);
            switch (statusBody.Status) {
                case "running": {
                    if (importHasStarted) {
                        statusProgress.rewindTo(0L);
                        statusProgress.add(100);
                        statusProgress.done();
                        break;
                    }
                    this.throwIfImportDidNotStart(importStartedTimeout);
                    break;
                }
                case "loading failed": {
                    if (importHasStarted) {
                        throw this.formatCommandFailedExceptionError(statusBody.Error.getMessage(), statusBody.Error.getUrl());
                    }
                    this.throwIfImportDidNotStart(importStartedTimeout);
                    break;
                }
                default: {
                    importHasStarted = true;
                    long elapsed = this.clock.millis() - importStarted;
                    statusProgress.rewindTo(0L);
                    statusProgress.add(this.importStatusProgressEstimate(statusBody.Status, elapsed, importTimeEstimateMillis));
                }
            }
            this.sleeper.sleep(2000L);
        }
        this.ctx.out().println("Your data was successfully pushed to Aura and is now running.");
        long importDurationMillis = this.clock.millis() - importStarted;
        this.debug(verbose, String.format("Import took about %d minutes to complete excluding upload (%d ms)", TimeUnit.MILLISECONDS.toMinutes(importDurationMillis), importDurationMillis));
    }

    int importStatusProgressEstimate(String databaseStatus, long elapsed, long importTimeEstimateMillis) {
        switch (databaseStatus) {
            case "running": {
                return 0;
            }
            case "updating": 
            case "loading": {
                int loadProgressEstimation = (int)Math.min(98L, elapsed * 98L / importTimeEstimateMillis);
                return 1 + loadProgressEstimation;
            }
        }
        throw new CommandFailedException(String.format("We're sorry, something has failed during the loading of your database. Please try again and if this problem persists, please open up a support case. Database status: %s", databaseStatus));
    }

    @Override
    public String authenticate(boolean verbose, String consoleUrl, String username, char[] password, boolean consentConfirmed) {
        return this.retryOnUnavailable(() -> this.doAuthenticate(verbose, consoleUrl, username, password, consentConfirmed));
    }

    private String doAuthenticate(boolean verbose, String consoleUrl, String username, char[] password, boolean consentConfirmed) throws IOException {
        URL url = HttpCopier.safeUrl(consoleUrl + "/import/auth");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        Closeable c = connection::disconnect;
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Authorization", "Basic " + HttpCopier.base64Encode(username, password));
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Confirmed", String.valueOf(consentConfirmed));
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 404: {
                throw this.errorResponse(verbose, connection, "We encountered a problem while contacting your Neo4j Aura instance, please check your Bolt URI");
            }
            case 301: {
                throw this.updatePluginErrorResponse(connection);
            }
            case 401: {
                throw this.errorResponse(verbose, connection, "Invalid username/password credentials");
            }
            case 403: {
                throw this.errorResponse(verbose, connection, "The credentials provided do not give administrative access to the target database");
            }
            case 409: {
                throw this.errorResponse(verbose, connection, "No consent to overwrite database. Aborting");
            }
            case 502: 
            case 503: 
            case 504: {
                throw new RetryableHttpException(this.unexpectedResponse(verbose, connection, "Authorization"));
            }
            case 200: {
                try (InputStream responseData = connection.getInputStream();){
                    String json = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
                    String string = HttpCopier.parseJsonUsingJacksonParser((String)json, TokenBody.class).Token;
                    return string;
                }
            }
        }
        throw this.unexpectedResponse(verbose, connection, "Authorization");
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    private URL initiateCopy(boolean verbose, URL importURL, long crc32Sum, long size, String bearerToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)importURL.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", bearerToken);
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            try (OutputStream postData = connection.getOutputStream();){
                postData.write(String.format("{\"Crc32\":%d, \"FullSize\":%d}", crc32Sum, size).getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 404: {
                    throw this.updatePluginErrorResponse(connection);
                }
                case 401: {
                    throw this.errorResponse(verbose, connection, "The given authorization token is invalid or has expired");
                }
                case 422: {
                    throw this.validationFailureErrorResponse(verbose, connection, size);
                }
                case 502: 
                case 503: 
                case 504: {
                    throw new RetryableHttpException(this.unexpectedResponse(verbose, connection, "Initiating upload target"));
                }
                case 202: {
                    URL uRL = HttpCopier.safeUrl(this.extractSignedURIFromResponse(verbose, connection));
                    return uRL;
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Initiating upload target");
        }
    }

    private URL initiateResumableUpload(boolean verbose, URL signedURL) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)signedURL.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Length", "0");
            connection.setFixedLengthStreamingMode(0);
            connection.setRequestProperty("x-goog-resumable", "start");
            connection.setRequestProperty("Content-Type", "");
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 201: {
                    URL uRL = HttpCopier.safeUrl(connection.getHeaderField("Location"));
                    return uRL;
                }
                case 502: 
                case 503: 
                case 504: {
                    throw new RetryableHttpException(this.unexpectedResponse(verbose, connection, "Initiating database upload"));
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Initiating database upload");
        }
    }

    private boolean resumeUpload(boolean verbose, Path source, String boltUri, long sourceLength, long position, URL uploadLocation, ProgressTrackingOutputStream.Progress uploadProgress) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uploadLocation.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setRequestMethod("PUT");
            long contentLength = sourceLength - position;
            connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            connection.setFixedLengthStreamingMode(contentLength);
            if (position > 0L) {
                connection.setRequestProperty("Content-Range", String.format("bytes %d-%d/%d", position, sourceLength - 1L, sourceLength));
            }
            connection.setDoOutput(true);
            uploadProgress.rewindTo(position);
            try (InputStream sourceStream = Files.newInputStream(source, new OpenOption[0]);
                 OutputStream targetStream = connection.getOutputStream();){
                HttpCopier.safeSkip(sourceStream, position);
                IOUtils.copy((InputStream)new BufferedInputStream(sourceStream), (OutputStream)new ProgressTrackingOutputStream(targetStream, uploadProgress));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    this.debugErrorResponse(verbose, connection);
                    boolean bl = false;
                    return bl;
                }
            }
            throw this.resumePossibleErrorResponse(connection, source, boltUri);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void triggerImportProtocol(boolean verbose, URL importURL, String boltUri, Path source, long crc32Sum, String bearerToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)importURL.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", bearerToken);
            connection.setDoOutput(true);
            try (OutputStream postData = connection.getOutputStream();){
                postData.write(String.format("{\"Crc32\":%d}", crc32Sum).getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 404: {
                    throw this.updatePluginErrorResponse(connection);
                }
                case 429: {
                    throw this.resumePossibleErrorResponse(connection, source, boltUri);
                }
                case 409: {
                    throw this.errorResponse(verbose, connection, "The target database contained data and consent to overwrite the data was not given. Aborting");
                }
                case 200: {
                    return;
                }
                default: {
                    throw this.resumePossibleErrorResponse(connection, source, boltUri);
                }
            }
        }
    }

    private StatusBody getDatabaseStatus(boolean verbose, URL statusURL, String bearerToken) {
        return this.retryOnUnavailable(() -> this.doGetDatabaseStatus(verbose, statusURL, bearerToken));
    }

    private StatusBody doGetDatabaseStatus(boolean verbose, URL statusURL, String bearerToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)statusURL.openConnection();
        Closeable c = connection::disconnect;
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Authorization", bearerToken);
        connection.setDoOutput(true);
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 301: 
            case 404: {
                throw this.updatePluginErrorResponse(connection);
            }
            case 200: {
                try (InputStream responseData = connection.getInputStream();){
                    String json = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
                    StatusBody statusBody = HttpCopier.parseJsonUsingJacksonParser(json, StatusBody.class);
                    return statusBody;
                }
            }
            case 502: 
            case 503: 
            case 504: {
                throw new RetryableHttpException(this.unexpectedResponse(verbose, connection, "Trigger import/restore after successful upload"));
            }
        }
        throw this.unexpectedResponse(verbose, connection, "Trigger import/restore after successful upload");
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    private long getResumablePosition(boolean verbose, long sourceLength, URL uploadLocation) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uploadLocation.openConnection();
        try (Closeable c = connection::disconnect;){
            this.debug(verbose, "Asking about resumable position for the upload");
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Length", "0");
            connection.setFixedLengthStreamingMode(0);
            connection.setRequestProperty("Content-Range", "bytes */" + sourceLength);
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 201: {
                    this.debug(verbose, "Upload seems to be completed got " + responseCode);
                    long l = -1L;
                    return l;
                }
                case 502: 
                case 503: 
                case 504: {
                    throw new RetryableHttpException(this.unexpectedResponse(verbose, connection, "Acquire resumable upload position"));
                }
                case 308: {
                    String range = connection.getHeaderField("Range");
                    this.debug(verbose, "Upload not completed got " + range);
                    long position = range == null ? 0L : HttpCopier.parseResumablePosition(range);
                    this.debug(verbose, "Parsed that as position " + position);
                    long l = position;
                    return l;
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Acquire resumable upload position");
        }
    }

    private String extractSignedURIFromResponse(boolean verbose, HttpURLConnection connection) throws IOException {
        try (InputStream responseData = connection.getInputStream();){
            String json = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
            this.debug(verbose, "Got json '" + json + "' back expecting to contain the signed URL");
            String string = HttpCopier.parseJsonUsingJacksonParser((String)json, SignedURIBody.class).SignedURI;
            return string;
        }
    }

    private void debug(boolean verbose, String string) {
        if (verbose) {
            this.ctx.out().println(string);
        }
    }

    private void debugErrorResponse(boolean verbose, HttpURLConnection connection) throws IOException {
        if (verbose) {
            String responseString;
            try (InputStream responseData = connection.getErrorStream();){
                responseString = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
            }
            this.debugResponse(true, responseString, connection, true);
        }
    }

    private void debugResponse(boolean verbose, String responseBody, HttpURLConnection connection, boolean error) throws IOException {
        if (verbose) {
            this.debug(true, error ? "=== Unexpected response ===" : "=== Response ===");
            this.debug(true, "Response message: " + connection.getResponseMessage());
            this.debug(true, "Response headers:");
            connection.getHeaderFields().forEach((key, value1) -> {
                for (String value : value1) {
                    this.debug(true, "  " + key + ": " + value);
                }
            });
            this.debug(true, "Response data: " + responseBody);
        }
    }

    private CommandFailedException errorResponse(boolean verbose, HttpURLConnection connection, String errorDescription) throws IOException {
        this.debugErrorResponse(verbose, connection);
        return new CommandFailedException(errorDescription);
    }

    private CommandFailedException resumePossibleErrorResponse(HttpURLConnection connection, Path dump, String boltUri) throws IOException {
        this.debugErrorResponse(true, connection);
        return new CommandFailedException("We encountered a problem while communicating to the Neo4j Aura system. \nYou can re-try using the existing dump by running this command: \n" + String.format("neo4j-admin push-to-cloud --%s=%s --%s=%s", "dump", dump.toAbsolutePath(), "bolt-uri", boltUri));
    }

    private CommandFailedException updatePluginErrorResponse(HttpURLConnection connection) throws IOException {
        this.debugErrorResponse(true, connection);
        return new CommandFailedException("We encountered a problem while communicating to the Neo4j Aura system. Please check that you are using the latest version of the push-to-cloud plugin and upgrade if necessary. If this problem persists after upgrading, please contact support and attach the logs shown below to your ticket in the support portal.");
    }

    private CommandFailedException validationFailureErrorResponse(boolean verbose, HttpURLConnection connection, long size) throws IOException {
        try (InputStream responseData = connection.getErrorStream();){
            String responseString = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
            this.debugResponse(verbose, responseString, connection, true);
            ErrorBody errorBody = HttpCopier.parseJsonUsingJacksonParser(responseString, ErrorBody.class);
            String message = errorBody.getMessage();
            if (ERROR_REASON_EXCEEDS_MAX_SIZE.equals(errorBody.getReason())) {
                String trimmedMessage = StringUtils.removeEnd((String)message, (String)".");
                message = String.format("%s. Minimum storage space required: %s", trimmedMessage, UploadCommand.sizeText(size));
            }
            CommandFailedException commandFailedException = this.formatCommandFailedExceptionError(message, errorBody.getUrl());
            return commandFailedException;
        }
    }

    private CommandFailedException unexpectedResponse(boolean verbose, HttpURLConnection connection, String requestDescription) throws IOException {
        return this.errorResponse(verbose, connection, String.format("Unexpected response code %d from request: %s", connection.getResponseCode(), requestDescription));
    }

    private CommandFailedException formatCommandFailedExceptionError(String message, String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return new CommandFailedException(message);
        }
        String trimmedMessage = StringUtils.removeEnd((String)message, (String)".");
        return new CommandFailedException(String.format("Error: %s. See: %s", trimmedMessage, url));
    }

    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }

    public static interface ProgressListenerFactory {
        public ProgressListener create(String var1, long var2);
    }

    private static interface IOExceptionSupplier<T> {
        public T get() throws IOException;
    }

    static class RetryableHttpException
    extends RuntimeException {
        RetryableHttpException(CommandFailedException e) {
            super((Throwable)e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class StatusBody {
        public String Status;
        public ErrorBody Error = new ErrorBody();

        StatusBody() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ErrorBody {
        private static final String DEFAULT_MESSAGE = "an unexpected problem ocurred, please contact customer support for assistance";
        private static final String DEFAULT_REASON = "UnknownError";
        private final String message;
        private final String reason;
        private final String url;

        ErrorBody() {
            this(null, null, null);
        }

        @JsonCreator
        ErrorBody(@JsonProperty(value="Message") String message, @JsonProperty(value="Reason") String reason, @JsonProperty(value="Url") String url) {
            this.message = message;
            this.reason = reason;
            this.url = url;
        }

        public String getMessage() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.message, (CharSequence)DEFAULT_MESSAGE);
        }

        public String getReason() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.reason, (CharSequence)DEFAULT_REASON);
        }

        public String getUrl() {
            return this.url;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TokenBody {
        public String Token;

        private TokenBody() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SignedURIBody {
        public String SignedURI;

        private SignedURIBody() {
        }
    }
}

