/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.aura;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AuraJsonMapper {
    private AuraJsonMapper() {
        throw new RuntimeException("Class should not be instantiated");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ErrorBody {
        private static final String DEFAULT_MESSAGE = "an unexpected problem occurred, please contact customer support for assistance";
        private static final String DEFAULT_REASON = "UnknownError";
        private final String message;
        private final String reason;
        private final String url;

        public ErrorBody() {
            this(null, null, null);
        }

        @JsonCreator
        public ErrorBody(@JsonProperty(value="Message") String message, @JsonProperty(value="Reason") String reason, @JsonProperty(value="Url") String url) {
            this.message = message;
            this.reason = reason;
            this.url = url;
        }

        public String getMessage() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.message, (CharSequence)DEFAULT_MESSAGE);
        }

        public String getReason() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.reason, (CharSequence)DEFAULT_REASON);
        }

        public String getUrl() {
            return this.url;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StatusBody {
        public String Status;
        public ErrorBody Error = new ErrorBody();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TriggerImportRequest {
        @JsonUnwrapped
        public UploadStatusResponse uploadStatusResponse;
        @JsonProperty(value="Crc32")
        public long Crc32;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UploadStatusResponse {
        public List<PartEtag> Parts;
        public String UploadID;
        public String Provider;

        public String toString() {
            return String.format("UploadID %s, Provider %s Parts: %s", this.UploadID, this.Provider, this.Parts.toString());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PartEtag {
        public int PartNumber;
        public String ETag;

        public String toString() {
            return String.format("[%d:%s]", this.PartNumber, this.ETag);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SignedURIBodyResponse {
        public String[] SignedLinks;
        public String SignedURI;
        public String UploadID;
        public int TotalParts;
        public String Provider;

        public String toString() {
            return String.format("SignedLinks %s, SignedURI %s, UploadID %s, TotalParts %s, Provider %s", Arrays.toString(this.SignedLinks), this.SignedURI, this.UploadID, this.TotalParts, this.Provider);
        }
    }
}

