/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;

public final class Util {
    private Util() {
    }

    public static URL safeUrl(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL '" + urlString + "'", e);
        }
    }

    public static String base64Encode(String username, char[] password) {
        String plainToken = username + ":" + String.valueOf(password);
        return Base64.getEncoder().encodeToString(plainToken.getBytes());
    }

    public static <T> T parseJsonUsingJacksonParser(String json, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(json, type);
    }
}

