/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.pushtocloud.PushToCloudConsole;
import picocli.CommandLine;

@CommandLine.Command(name="push-to-cloud", description={"Push your local database to a Neo4j Aura instance. The database must be shutdown in order to take a dump to upload. The target location is your Neo4j Aura Bolt URI. You will be asked your Neo4j Cloud username and password during the push-to-cloud operation."})
public class PushToCloudCommand
extends AbstractCommand {
    private final Copier copier;
    private final DumpCreator dumpCreator;
    private final PushToCloudConsole cons;
    @CommandLine.Option(names={"--database"}, description={"Name of the database to push. Defaults to neo4jThis argument cannot be used together with --dump."}, converter={Converters.DatabaseNameConverter.class})
    private NormalizedDatabaseName database;
    @CommandLine.Option(names={"--dump"}, description={"'/path/to/my-neo4j-database-dump-file' Path to an existing database dump for upload. This argument cannot be used together with --database."})
    private File dump;
    @CommandLine.Option(names={"--temp-file-location", "--dump-to"}, description={"'/path/to/temp-file' Target path for temporary database dump file to be uploaded. Used in combination with the --database argument."})
    private File tmpDumpFile;
    @CommandLine.Option(names={"--bolt-uri"}, arity="1", required=true, description={"'neo4j://mydatabaseid.databases.neo4j.io' Bolt URI of target database"})
    private String boltURI;
    @CommandLine.Option(names={"--username"}, defaultValue="${NEO4J_USERNAME}", description={"Optional: Username of the target database to push this database to. Prompt will ask for username if not provided. Alternatively NEO4J_USERNAME environment variable can be used."})
    private String username;
    @CommandLine.Option(names={"--password"}, defaultValue="${NEO4J_PASSWORD}", description={"Optional: Password of the target database to push this database to. Prompt will ask for password if not provided. Alternatively NEO4J_PASSWORD environment variable can be used."})
    private String password;
    @CommandLine.Option(names={"--overwrite"}, description={"Optional: Overwrite the data in the target database."})
    private boolean overwrite;

    public PushToCloudCommand(ExecutionContext ctx, Copier copier, DumpCreator dumpCreator, PushToCloudConsole cons) {
        super(ctx);
        this.copier = copier;
        this.dumpCreator = dumpCreator;
        this.cons = cons;
    }

    public void execute() {
        try {
            char[] pass;
            if ((this.database == null || StringUtils.isBlank((CharSequence)this.database.name())) && (this.dump == null || StringUtils.isBlank((CharSequence)this.dump.toString()))) {
                this.database = new NormalizedDatabaseName("neo4j");
            }
            if (StringUtils.isBlank((CharSequence)this.username) && StringUtils.isBlank((CharSequence)(this.username = this.cons.readLine("%s", "Neo4j aura username (default: neo4j):")))) {
                this.username = "neo4j";
            }
            if (StringUtils.isBlank((CharSequence)this.password)) {
                pass = this.cons.readPassword("Neo4j aura password for %s:", this.username);
                if (pass.length == 0) {
                    throw new CommandFailedException("Please supply a password, either by '--password' parameter, 'NEO4J_PASSWORD' environment variable, or prompt");
                }
            } else {
                pass = this.password.toCharArray();
            }
            String consoleURL = this.buildConsoleURI(this.boltURI);
            String bearerToken = this.copier.authenticate(this.verbose, consoleURL, this.username, pass, this.overwrite);
            long size = this.sourceSize(this.ctx, this.dump, this.database);
            this.copier.checkSize(this.verbose, consoleURL, size, bearerToken);
            Path source = this.initiateSource(this.ctx, this.dump, this.database, this.tmpDumpFile);
            boolean deleteDump = this.dump == null;
            this.copier.copy(this.verbose, consoleURL, this.boltURI, source, deleteDump, bearerToken);
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace(this.ctx.out());
            }
            throw e;
        }
    }

    private String buildConsoleURI(String boltURI) throws CommandFailedException {
        Pattern pattern = Pattern.compile("(?:bolt(?:\\+routing)?|neo4j(?:\\+s|\\+ssc)?)://([^-]+)(-(.+))?.databases.neo4j.io$");
        Matcher matcher = pattern.matcher(boltURI);
        if (!matcher.matches()) {
            throw new CommandFailedException("Invalid Bolt URI '" + boltURI + "'");
        }
        String databaseId = matcher.group(1);
        String environment = matcher.group(2);
        return String.format("https://console%s.neo4j.io/v1/databases/%s", environment == null ? "" : environment, databaseId);
    }

    private Path initiateSource(ExecutionContext ctx, File dump, NormalizedDatabaseName database, File to) throws CommandFailedException {
        Path dumpFile;
        if (dump != null && database != null) {
            throw new CommandFailedException("Provide either a dump or database name, not both");
        }
        if (dump != null) {
            Path path = dump.toPath();
            if (!Files.exists(path, new LinkOption[0])) {
                throw new CommandFailedException(String.format("The provided dump '%s' file doesn't exist", path));
            }
            return path;
        }
        Path path = dumpFile = to != null ? to.toPath() : ctx.homeDir().resolve("dump-of-" + database + "-" + System.currentTimeMillis());
        if (Files.exists(dumpFile, new LinkOption[0])) {
            throw new CommandFailedException(String.format("The provided dump-to target '%s' file already exists", dumpFile));
        }
        this.dumpCreator.dumpDatabase(database.name(), dumpFile);
        return dumpFile;
    }

    private long sourceSize(ExecutionContext ctx, File dump, NormalizedDatabaseName database) throws CommandFailedException {
        long txLogSize;
        if (dump != null && database != null) {
            throw new CommandFailedException("Provide either a dump or database name, not both");
        }
        if (dump != null) {
            Loader.DumpMetaData metaData;
            Path path = dump.toPath();
            try {
                metaData = new Loader(System.out).getMetaData(path);
            }
            catch (IOException e) {
                throw new CommandFailedException("Unable to check size of database dump.", (Throwable)e);
            }
            return Long.parseLong(metaData.byteCount);
        }
        File configFile = ctx.confDir().resolve("neo4j.conf").toFile();
        DatabaseLayout layout = Neo4jLayout.of((Config)this.getConfig(configFile)).databaseLayout(database.name());
        long storeFilesSize = FileUtils.sizeOf((File)layout.databaseDirectory());
        try {
            txLogSize = FileUtils.sizeOf((File)layout.getTransactionLogsDirectory());
        }
        catch (IllegalArgumentException e) {
            txLogSize = 0L;
        }
        return txLogSize + storeFilesSize;
    }

    private Config getConfig(File configFile) {
        if (!this.ctx.fs().fileExists(configFile)) {
            throw new CommandFailedException("Unable to find config file, tried: " + configFile.getAbsolutePath());
        }
        try {
            return Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir().toAbsolutePath()).build();
        }
        catch (Exception e) {
            throw new CommandFailedException("Failed to read config file: " + configFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public static interface DumpCreator {
        public void dumpDatabase(String var1, Path var2) throws CommandFailedException;
    }

    public static interface Copier {
        public String authenticate(boolean var1, String var2, String var3, char[] var4, boolean var5) throws CommandFailedException;

        public void copy(boolean var1, String var2, String var3, Path var4, boolean var5, String var6) throws CommandFailedException;

        public void checkSize(boolean var1, String var2, long var3, String var5) throws CommandFailedException;
    }
}

