/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.neo4j.dbms.archive.CompressionFormat;

public class DumpMetaData {
    public final String format;
    public final String fileCount;
    public final String byteCount;

    private DumpMetaData(String format, String fileCount, String byteCount) {
        this.format = format;
        this.fileCount = fileCount;
        this.byteCount = byteCount;
    }

    public static DumpMetaData getMetaData(Path archive) throws IOException {
        Throwable throwable = null;
        try (InputStream input = Files.newInputStream(archive, new OpenOption[0]);){
            InputStream decompressor = CompressionFormat.ZSTD.decompress(input);
            DataInputStream metadata = new DataInputStream(decompressor);
            int version = metadata.readInt();
            if (version == 1) {
                String format = "Neo4j ZSTD Dump.";
                String fileCount = String.valueOf(metadata.readLong());
                String byteCount = String.valueOf(metadata.readLong());
                DumpMetaData dumpMetaData = new DumpMetaData(format, fileCount, byteCount);
                return dumpMetaData;
            }
            try {
                throw new IOException("Cannot read archive meta-data. I don't recognise this archive version: " + version + ".");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

