/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.nio.file.Path;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.pushtocloud.HttpCopier;
import org.neo4j.pushtocloud.PushToCloudCommand;
import org.neo4j.pushtocloud.RealDumpCreator;

public class PushToCloudCommandProvider
extends AdminCommand.Provider {
    public PushToCloudCommandProvider() {
        super("push-to-cloud", new String[0]);
    }

    public Arguments allArguments() {
        return PushToCloudCommand.arguments;
    }

    public String summary() {
        return "Push database to Neo4j cloud";
    }

    public AdminCommandSection commandSection() {
        return AdminCommandSection.general();
    }

    public String description() {
        return "Push your local database to a Neo4j cloud instance. The database must be shutdown in order to take a dump to upload. The target location is your Neo4j Cloud Bolt URI. You will be asked your Neo4j Cloud username and password during the push-to-cloud operation.";
    }

    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new PushToCloudCommand(homeDir, configDir, outsideWorld, new HttpCopier(outsideWorld), new RealDumpCreator(homeDir, configDir, outsideWorld));
    }
}

