/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.apache.commons.compress.utils.IOUtils;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.pushtocloud.ProgressTrackingOutputStream;
import org.neo4j.pushtocloud.PushToCloudCommand;

public class HttpCopier
implements PushToCloudCommand.Copier {
    static final int HTTP_RESUME_INCOMPLETE = 308;
    static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final long POSITION_UPLOAD_COMPLETED = -1L;
    private static final long MAXIMUM_RETRY_BACKOFF = TimeUnit.SECONDS.toMillis(64L);
    private final OutsideWorld outsideWorld;
    private final Sleeper sleeper;
    private final ProgressListenerFactory progressListenerFactory;

    HttpCopier(OutsideWorld outsideWorld) {
        this(outsideWorld, Thread::sleep, (text, length) -> ProgressMonitorFactory.textual((OutputStream)outsideWorld.outStream()).singlePart(text, length));
    }

    HttpCopier(OutsideWorld outsideWorld, Sleeper sleeper, ProgressListenerFactory progressListenerFactory) {
        this.outsideWorld = outsideWorld;
        this.sleeper = sleeper;
        this.progressListenerFactory = progressListenerFactory;
    }

    @Override
    public void copy(boolean verbose, String consoleURL, String boltUri, Path source, String bearerToken) throws CommandFailed {
        try {
            String bearerTokenHeader = "Bearer " + bearerToken;
            long crc32Sum = HttpCopier.calculateCrc32HashOfFile(source);
            URL signedURL = this.initiateCopy(verbose, HttpCopier.safeUrl(consoleURL + "/import"), crc32Sum, source.toFile().length(), bearerTokenHeader);
            URL uploadLocation = this.initiateResumableUpload(verbose, signedURL);
            long sourceLength = this.outsideWorld.fileSystem().getFileSize(source.toFile());
            long position = 0L;
            int retries = 0;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            ProgressTrackingOutputStream.Progress uploadProgress = new ProgressTrackingOutputStream.Progress(this.progressListenerFactory.create("Upload", sourceLength), position);
            while (!this.resumeUpload(verbose, source, boltUri, sourceLength, position, uploadLocation, uploadProgress) && (position = this.getResumablePosition(verbose, sourceLength, uploadLocation)) != -1L) {
                if (retries > 50) {
                    throw new CommandFailed("Upload failed after numerous attempts. The upload can be resumed with this command: TODO");
                }
                long backoffFromRetryCount = TimeUnit.SECONDS.toMillis(1 << retries++) + (long)random.nextInt(1000);
                this.sleeper.sleep(Long.min(backoffFromRetryCount, MAXIMUM_RETRY_BACKOFF));
            }
            uploadProgress.done();
            this.triggerImportProtocol(verbose, HttpCopier.safeUrl(consoleURL + "/import/upload-complete"), boltUri, source, crc32Sum, bearerTokenHeader);
            this.doStatusPolling(verbose, consoleURL, bearerToken);
        }
        catch (IOException | InterruptedException e) {
            throw new CommandFailed(e.getMessage(), (Throwable)e);
        }
    }

    private void doStatusPolling(boolean verbose, String consoleURL, String bearerToken) throws IOException, InterruptedException, CommandFailed {
        this.outsideWorld.stdOutLine("We have received your export and it is currently being loaded into your cloud instance.");
        this.outsideWorld.stdOutLine("You can wait here, or abort this command and head over to the console to be notified of when your database is running.");
        String bearerTokenHeader = "Bearer " + bearerToken;
        ProgressTrackingOutputStream.Progress statusProgress = new ProgressTrackingOutputStream.Progress(this.progressListenerFactory.create("Import status", 3L), 0L);
        boolean firstRunning = true;
        long importStartedTimeout = System.currentTimeMillis() + 90000L;
        while (!statusProgress.isDone()) {
            String status;
            switch (status = this.getDatabaseStatus(verbose, HttpCopier.safeUrl(consoleURL + "/import/status"), bearerTokenHeader)) {
                case "running": {
                    boolean passedStartImportTimeout;
                    if (!firstRunning) {
                        statusProgress.rewindTo(0L);
                        statusProgress.add(3);
                        statusProgress.done();
                        break;
                    }
                    boolean bl = passedStartImportTimeout = System.currentTimeMillis() > importStartedTimeout;
                    if (!passedStartImportTimeout) break;
                    throw new CommandFailed("We're sorry, it couldn't be detected that the import was started, please check the console for further details.");
                }
                case "loading": {
                    firstRunning = false;
                    statusProgress.rewindTo(0L);
                    statusProgress.add(1);
                    break;
                }
                case "restoring": {
                    firstRunning = false;
                    statusProgress.rewindTo(0L);
                    statusProgress.add(2);
                    break;
                }
                case "loading failed": {
                    throw new CommandFailed("We're sorry, something has gone wrong. We did not recognize the file you uploaded as a valid Neo4j dump file. Please check the file and try again. If you have received this error after confirming the type of file being uploaded,please open a support case.");
                }
                default: {
                    throw new CommandFailed(String.format("We're sorry, something has failed during the loading of your database. Please try again and if this problem persists, please open up a support case. Database status: %s", status));
                }
            }
            this.sleeper.sleep(2000L);
        }
        this.outsideWorld.stdOutLine("Your data was successfully pushed to cloud and is now running.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String authenticate(boolean verbose, String consoleUrl, String username, char[] password, boolean consentConfirmed) throws CommandFailed {
        try {
            URL url = HttpCopier.safeUrl(consoleUrl + "/import/auth");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Basic " + HttpCopier.base64Encode(username, password));
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Confirmed", String.valueOf(consentConfirmed));
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 404: {
                    throw this.updatePluginErrorResponse(connection);
                }
                case 401: {
                    throw this.errorResponse(verbose, connection, "Invalid username/password credentials");
                }
                case 403: {
                    throw this.errorResponse(verbose, connection, "The credentials provided do not give administrative access to the target database");
                }
                case 409: {
                    boolean consent = this.askForBooleanConsent("The target database contains data. Overwrite it? (Yes/No)");
                    if (!consent) throw this.errorResponse(verbose, connection, "No consent to overwrite database. Aborting");
                    String string = this.authenticate(verbose, consoleUrl, username, password, true);
                    return string;
                }
                case 200: {
                    try (InputStream responseData = connection.getInputStream();){
                        String json = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
                        String string = HttpCopier.parseJsonUsingJacksonParser((String)json, TokenBody.class).Token;
                        return string;
                    }
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Authorization");
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            throw new CommandFailed(e.getMessage(), (Throwable)e);
        }
    }

    private URL initiateCopy(boolean verbose, URL importURL, long crc32Sum, long fileSize, String bearerToken) throws IOException, CommandFailed {
        HttpURLConnection connection = (HttpURLConnection)importURL.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", bearerToken);
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            Serializable serializable = null;
            try (OutputStream postData = connection.getOutputStream();){
                postData.write(HttpCopier.buildCrc32WithConsentJson(crc32Sum, fileSize).getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 404: {
                    throw this.updatePluginErrorResponse(connection);
                }
                case 401: {
                    throw this.errorResponse(verbose, connection, "The given authorization token is invalid or has expired");
                }
                case 202: {
                    serializable = HttpCopier.safeUrl(this.extractSignedURIFromResponse(verbose, connection));
                    return serializable;
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Initiating upload target");
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL initiateResumableUpload(boolean verbose, URL signedURL) throws IOException, CommandFailed {
        HttpURLConnection connection = (HttpURLConnection)signedURL.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Length", "0");
            connection.setFixedLengthStreamingMode(0);
            connection.setRequestProperty("x-goog-resumable", "start");
            connection.setRequestProperty("Content-Type", "");
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            if (responseCode != 201) {
                throw this.unexpectedResponse(verbose, connection, "Initiating database upload");
            }
            URL uRL = HttpCopier.safeUrl(connection.getHeaderField("Location"));
            return uRL;
        }
        finally {
            connection.disconnect();
        }
    }

    private boolean resumeUpload(boolean verbose, Path source, String boltUri, long sourceLength, long position, URL uploadLocation, ProgressTrackingOutputStream.Progress uploadProgress) throws IOException, CommandFailed {
        HttpURLConnection connection = (HttpURLConnection)uploadLocation.openConnection();
        try {
            connection.setRequestMethod("PUT");
            long contentLength = sourceLength - position;
            connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            connection.setFixedLengthStreamingMode(contentLength);
            if (position > 0L) {
                connection.setRequestProperty("Content-Range", String.format("bytes %d-%d/%d", position, sourceLength - 1L, sourceLength));
            }
            connection.setDoOutput(true);
            uploadProgress.rewindTo(position);
            try (FileInputStream sourceStream = new FileInputStream(source.toFile());
                 OutputStream targetStream = connection.getOutputStream();){
                HttpCopier.safeSkip(sourceStream, position);
                IOUtils.copy((InputStream)new BufferedInputStream(sourceStream), (OutputStream)new ProgressTrackingOutputStream(targetStream, uploadProgress));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 500: 
                case 503: {
                    this.debugErrorResponse(verbose, connection);
                    boolean bl = false;
                    return bl;
                }
            }
            throw this.resumePossibleErrorResponse(connection, source, boltUri);
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void triggerImportProtocol(boolean verbose, URL importURL, String boltUri, Path source, long crc32Sum, String bearerToken) throws IOException, CommandFailed {
        HttpURLConnection connection = (HttpURLConnection)importURL.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", bearerToken);
            connection.setDoOutput(true);
            try (OutputStream postData = connection.getOutputStream();){
                postData.write(HttpCopier.buildCrc32WithConsentJson(crc32Sum, null).getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 404: {
                    throw this.updatePluginErrorResponse(connection);
                }
                case 429: {
                    throw this.resumePossibleErrorResponse(connection, source, boltUri);
                }
                case 409: {
                    throw this.errorResponse(verbose, connection, "The target database contained data and consent to overwrite the data was not given. Aborting");
                }
                case 200: {
                    return;
                }
                default: {
                    throw this.resumePossibleErrorResponse(connection, source, boltUri);
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private String getDatabaseStatus(boolean verbose, URL statusURL, String bearerToken) throws IOException, CommandFailed {
        HttpURLConnection connection = (HttpURLConnection)statusURL.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Authorization", bearerToken);
        connection.setDoOutput(true);
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 301: 
            case 404: {
                throw this.updatePluginErrorResponse(connection);
            }
            case 200: {
                try (InputStream responseData = connection.getInputStream();){
                    String json = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
                    String string = HttpCopier.parseJsonUsingJacksonParser((String)json, StatusBody.class).Status;
                    return string;
                }
            }
        }
        throw this.unexpectedResponse(verbose, connection, "Trigger import/restore after successful upload");
        finally {
            connection.disconnect();
        }
    }

    private long getResumablePosition(boolean verbose, long sourceLength, URL uploadLocation) throws IOException, CommandFailed {
        this.debug(verbose, "Asking about resumable position for the upload");
        HttpURLConnection connection = (HttpURLConnection)uploadLocation.openConnection();
        try {
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Length", "0");
            connection.setFixedLengthStreamingMode(0);
            connection.setRequestProperty("Content-Range", "bytes */" + sourceLength);
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 201: {
                    this.debug(verbose, "Upload seems to be completed got " + responseCode);
                    long l = -1L;
                    return l;
                }
                case 308: {
                    String range = connection.getHeaderField("Range");
                    this.debug(verbose, "Upload not completed got " + range);
                    long position = range == null ? 0L : HttpCopier.parseResumablePosition(range);
                    this.debug(verbose, "Parsed that as position " + position);
                    long l = position;
                    return l;
                }
            }
            throw this.unexpectedResponse(verbose, connection, "Acquire resumable upload position");
        }
        finally {
            connection.disconnect();
        }
    }

    private static String buildCrc32WithConsentJson(long crc32Sum, Long fileSize) {
        String fileSizeString = "";
        if (fileSize != null) {
            fileSizeString = String.format(", \"DumpSize\":%d", fileSize);
        }
        return String.format("{\"Crc32\":%d%s}", crc32Sum, fileSizeString);
    }

    private static void safeSkip(InputStream sourceStream, long position) throws IOException {
        for (long toSkip = position; toSkip > 0L; toSkip -= sourceStream.skip(position)) {
        }
    }

    private static long parseResumablePosition(String range) throws CommandFailed {
        int dashIndex = range.indexOf(45);
        if (!range.startsWith("bytes=") || dashIndex == -1) {
            throw new CommandFailed("Unexpected response when asking where to resume upload from. got '" + range + "'");
        }
        return Long.parseLong(range.substring(dashIndex + 1)) + 1L;
    }

    private boolean askForBooleanConsent(String message) {
        while (true) {
            String input;
            if ((input = this.outsideWorld.promptLine(message, new Object[0])) != null) {
                if ((input = input.toLowerCase()).equals("yes") || input.equals("y") || input.equals("true")) {
                    return true;
                }
                if (input.equals("no") || input.equals("n") || input.equals("false")) {
                    return false;
                }
            }
            this.outsideWorld.stdOutLine("Sorry, I didn't understand your answer. Please reply with yes/y or no/n");
        }
    }

    private static String base64Encode(String username, char[] password) {
        String plainToken = username + ":" + password;
        return Base64.getEncoder().encodeToString(plainToken.getBytes());
    }

    private String extractSignedURIFromResponse(boolean verbose, HttpURLConnection connection) throws IOException, CommandFailed {
        try (InputStream responseData = connection.getInputStream();){
            String json = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
            this.debug(verbose, "Got json '" + json + "' back expecting to contain the signed URL");
            String string = HttpCopier.parseJsonUsingJacksonParser((String)json, SignedURIBody.class).SignedURI;
            return string;
        }
    }

    private void debug(boolean verbose, String string) {
        if (verbose) {
            this.outsideWorld.stdOutLine(string);
        }
    }

    private void debugErrorResponse(boolean verbose, HttpURLConnection connection) throws IOException {
        this.debugResponse(verbose, connection, false);
    }

    private void debugResponse(boolean verbose, HttpURLConnection connection, boolean successful) throws IOException {
        if (verbose) {
            this.debug(true, "=== Unexpected response ===");
            this.debug(true, "Response message: " + connection.getResponseMessage());
            this.debug(true, "Response headers:");
            connection.getHeaderFields().forEach((key, value1) -> {
                for (String value : value1) {
                    this.debug(true, "  " + key + ": " + value);
                }
            });
            try (InputStream responseData = successful ? connection.getInputStream() : connection.getErrorStream();){
                String responseString = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
                this.debug(true, "Error response data: " + responseString);
            }
        }
    }

    private static long calculateCrc32HashOfFile(Path source) throws IOException {
        CRC32 crc = new CRC32();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source.toFile()));){
            int cnt;
            while ((cnt = ((InputStream)inputStream).read()) != -1) {
                crc.update(cnt);
            }
        }
        return crc.getValue();
    }

    private static URL safeUrl(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL '" + urlString + "'", e);
        }
    }

    private static <T> T parseJsonUsingJacksonParser(String json, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(json, type);
    }

    private CommandFailed errorResponse(boolean verbose, HttpURLConnection connection, String errorDescription) throws IOException {
        this.debugErrorResponse(verbose, connection);
        return new CommandFailed(errorDescription);
    }

    private CommandFailed resumePossibleErrorResponse(HttpURLConnection connection, Path dump, String boltUri) throws IOException {
        this.debugErrorResponse(true, connection);
        return new CommandFailed("We encountered a problem while communicating to the Neo4j cloud system. \nYou can re-try using the existing dump by running this command: \n" + String.format("neo4j-admin push-to-cloud --%s=%s --$s=%s", "dump", dump.toFile().getAbsolutePath(), "bolt-uri", boltUri));
    }

    private CommandFailed updatePluginErrorResponse(HttpURLConnection connection) throws IOException {
        this.debugErrorResponse(true, connection);
        return new CommandFailed("We encountered a problem while communicating to the Neo4j cloud system. Please check that you are using the latest version of the push-to-cloud plugin and upgrade if necessary. If this problem persists after upgrading, please contact support and attach the logs shown below to your ticket in the support portal.");
    }

    private CommandFailed unexpectedResponse(boolean verbose, HttpURLConnection connection, String requestDescription) throws IOException {
        return this.errorResponse(verbose, connection, String.format("Unexpected response code %d from request: %s", connection.getResponseCode(), requestDescription));
    }

    public static interface ProgressListenerFactory {
        public ProgressListener create(String var1, long var2);
    }

    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class StatusBody {
        public String Status;

        private StatusBody() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TokenBody {
        public String Token;

        private TokenBody() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SignedURIBody {
        public String SignedURI;

        private SignedURIBody() {
        }
    }
}

