/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.common.Database;
import org.neo4j.helpers.Args;

public class PushToCloudCommand
implements AdminCommand {
    static final String ARG_DATABASE = "database";
    static final String ARG_BOLT_URI = "bolt-uri";
    static final String ARG_DUMP = "dump";
    static final String ARG_DUMP_TO = "dump-to";
    static final String ARG_VERBOSE = "v";
    static final String ARG_CONFIRMED = "confirmed";
    static final String ARG_USERNAME = "username";
    static final String ARG_PASSWORD = "password";
    static final String ENV_USERNAME = "NEO4J_USERNAME";
    static final String ENV_PASSWORD = "NEO4J_PASSWORD";
    static final Arguments arguments = new Arguments().withDatabase().withArgument((NamedArgument)new OptionalNamedArg("dump", "/path/to/my-neo4j-database-dump-file", null, "Existing dump of a database, produced from the dump command")).withArgument((NamedArgument)new OptionalNamedArg("dump-to", "/path/to/dump-file-to-be-created", null, "Location to create the dump file if database is given. The database will be dumped to this file instead of a default location")).withArgument((NamedArgument)new MandatoryNamedArg("bolt-uri", "bolt+routing://mydatabaseid.databases.neo4j.io", "Bolt URI pointing out the target location to push the database to")).withArgument((NamedArgument)new OptionalNamedArg("v", "true/false", null, "Whether or not to be verbose about internal details and errors.")).withArgument((NamedArgument)new OptionalNamedArg("username", "neo4j", null, "Optional: Username of the target database to push this database to. Prompt will ask for username if not provided. Alternatively NEO4J_USERNAME environment variable can be used.")).withArgument((NamedArgument)new OptionalNamedArg("password", "true/false", null, "Optional: Password of the target database to push this database to. Prompt will ask for password if not provided. Alternatively NEO4J_PASSWORD environment variable can be used.")).withArgument((NamedArgument)new OptionalNamedArg("confirmed", "true/false", "false", "Optional: Allow import to continue even if it will overwrite data in a non-empty cloud database."));
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;
    private final Copier copier;
    private final DumpCreator dumpCreator;

    public PushToCloudCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld, Copier copier, DumpCreator dumpCreator) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
        this.copier = copier;
        this.dumpCreator = dumpCreator;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Args arguments = Args.parse((String[])args);
        boolean verbose = arguments.getBoolean(ARG_VERBOSE);
        try {
            String passwordFromArg = arguments.get(ARG_PASSWORD);
            String username = arguments.get(ARG_USERNAME);
            String usernameFromEnv = System.getenv(ENV_USERNAME);
            String passwordFromEnv = System.getenv(ENV_PASSWORD);
            if (username == null && passwordFromArg != null || username != null && passwordFromArg == null) {
                throw new IncorrectUsage("Provide either 'username' and 'password' as argument or none.");
            }
            if (usernameFromEnv == null && passwordFromEnv != null || usernameFromEnv != null && passwordFromEnv == null) {
                throw new IncorrectUsage("Provide either 'ENV_USERNAME' and 'ENV_PASSWORD' as environment variable or none.");
            }
            if (passwordFromEnv != null && passwordFromArg != null) {
                throw new IncorrectUsage("It is not allowed to provide 'username' and 'password' as argument and environment variable.");
            }
            if (username == null) {
                username = usernameFromEnv != null ? usernameFromEnv : this.outsideWorld.promptLine("Neo4j cloud database user name: ", new Object[0]);
            }
            char[] password = passwordFromArg != null ? passwordFromArg.toCharArray() : (passwordFromEnv != null ? passwordFromEnv.toCharArray() : this.outsideWorld.promptPassword("Neo4j cloud database password: ", new Object[0]));
            String boltURI = arguments.get(ARG_BOLT_URI);
            String confirmationViaArgument = arguments.get(ARG_CONFIRMED);
            String consoleURL = this.buildConsoleURI(boltURI);
            String bearerToken = this.copier.authenticate(verbose, consoleURL, username, password, "true".equals(confirmationViaArgument));
            Path source = this.initiateSource(arguments);
            this.copier.copy(verbose, consoleURL, source, bearerToken);
        }
        catch (Exception e) {
            if (verbose) {
                this.outsideWorld.printStacktrace(e);
            }
            throw e;
        }
    }

    private String buildConsoleURI(String boltURI) throws IncorrectUsage {
        Pattern pattern = Pattern.compile("bolt\\+routing://([^-]+)(-(.+))?.databases.neo4j.io$");
        Matcher matcher = pattern.matcher(boltURI);
        if (!matcher.matches()) {
            throw new IncorrectUsage("Invalid Bolt URI '" + boltURI + "'");
        }
        String databaseId = matcher.group(1);
        String environment = matcher.group(2);
        return String.format("https://console%s.neo4j.io/v1/databases/%s", environment == null ? "" : environment, databaseId);
    }

    private Path initiateSource(Args arguments) throws IncorrectUsage, CommandFailed {
        String to;
        Path dumpFile;
        String dump = arguments.get(ARG_DUMP);
        String database = arguments.get(ARG_DATABASE);
        if (dump != null && database != null) {
            throw new IncorrectUsage("Provide either a dump or database name, not both");
        }
        if (dump != null) {
            Path path = Paths.get(dump, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new CommandFailed(String.format("The provided dump '%s' file doesn't exist", path));
            }
            return path;
        }
        if (database == null) {
            database = new Database().defaultValue();
            this.outsideWorld.stdOutLine("Selecting default database '" + database + "'");
        }
        Path path = dumpFile = (to = arguments.get(ARG_DUMP_TO)) != null ? Paths.get(to, new String[0]) : this.homeDir.resolve("dump-of-" + database + "-" + System.currentTimeMillis());
        if (Files.exists(dumpFile, new LinkOption[0])) {
            throw new CommandFailed(String.format("The provided dump-to target '%s' file already exists", dumpFile));
        }
        this.dumpCreator.dumpDatabase(database, dumpFile);
        return dumpFile;
    }

    public static interface DumpCreator {
        public void dumpDatabase(String var1, Path var2) throws CommandFailed, IncorrectUsage;
    }

    public static interface Copier {
        public String authenticate(boolean var1, String var2, String var3, char[] var4, boolean var5) throws CommandFailed;

        public void copy(boolean var1, String var2, Path var3, String var4) throws CommandFailed;
    }
}

