/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.util;

import java.io.IOException;
import java.io.OutputStream;
import org.neo4j.internal.helpers.progress.ProgressListener;

public class ProgressTrackingOutputStream
extends OutputStream {
    private final OutputStream actual;
    private final Progress progress;

    public ProgressTrackingOutputStream(OutputStream actual, Progress progress) {
        this.actual = actual;
        this.progress = progress;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.actual.write(b, off, len);
        this.progress.add(len);
    }

    @Override
    public void flush() throws IOException {
        this.actual.flush();
    }

    @Override
    public void close() throws IOException {
        this.actual.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.actual.write(b);
        this.progress.add(1);
    }

    public static class Progress {
        private final ProgressListener uploadProgress;
        private long highestReportedProgress;
        private long progress;
        private boolean done;

        public Progress(ProgressListener progressListener, long position) {
            this.uploadProgress = progressListener;
            if (position > 0L) {
                this.uploadProgress.add(position);
            }
        }

        public void add(int increment) {
            this.progress += (long)increment;
            if (this.progress > this.highestReportedProgress) {
                this.uploadProgress.add(this.progress - this.highestReportedProgress);
                this.highestReportedProgress = this.progress;
            }
        }

        public void rewindTo(long absoluteProgress) {
            this.progress = absoluteProgress;
        }

        public void done() {
            this.done = true;
            this.uploadProgress.close();
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

