/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.providers;

import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.CommandResponseHandler;
import org.neo4j.export.UploadURLFactory;
import org.neo4j.export.aura.AuraJsonMapper;
import org.neo4j.export.providers.SignedUpload;
import org.neo4j.export.providers.SignedUploadAWS;
import org.neo4j.export.providers.SignedUploadGCP;

public class SignedUploadURLFactory
implements UploadURLFactory {
    @Override
    public SignedUpload fromAuraResponse(AuraJsonMapper.SignedURIBodyResponse signedURIBodyResponse, ExecutionContext ctx, String boltURI) {
        if (signedURIBodyResponse.Provider.equalsIgnoreCase(Provider.AWS.name)) {
            return new SignedUploadAWS(signedURIBodyResponse.SignedLinks, signedURIBodyResponse.UploadID, signedURIBodyResponse.TotalParts, ctx, boltURI);
        }
        return new SignedUploadGCP(signedURIBodyResponse.SignedLinks, signedURIBodyResponse.SignedURI, ctx, boltURI, new CommandResponseHandler(ctx));
    }

    public static enum Provider {
        AWS("AWS"),
        GCP("GCP");

        private final String name;

        private Provider(String name) {
            this.name = name;
        }
    }

    static class RetryableHttpException
    extends RuntimeException {
        RetryableHttpException(CommandFailedException e) {
            super((Throwable)e);
        }
    }
}

