/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.utils.IOUtils;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;

public class CommandResponseHandler {
    private final ExecutionContext ctx;

    public CommandResponseHandler(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    public CommandFailedException unexpectedResponse(boolean verbose, HttpURLConnection connection, String requestDescription) throws IOException {
        this.debugErrorResponse(verbose, connection);
        return new CommandFailedException(String.format("Unexpected response code %d from request: %s", connection.getResponseCode(), requestDescription));
    }

    public void debugErrorResponse(boolean verbose, HttpURLConnection connection) throws IOException {
        if (verbose) {
            String responseString;
            InputStream errorStream = connection.getErrorStream();
            try (InputStream responseData = errorStream != null ? errorStream : connection.getInputStream();){
                responseString = new String(IOUtils.toByteArray((InputStream)responseData), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to read response from server: %s", e.getMessage()), e);
            }
            this.debugResponse(responseString, connection, true);
        }
    }

    public void debugResponse(String responseBody, HttpURLConnection connection, boolean error) throws IOException {
        this.debug(true, error ? "=== Unexpected response ===" : "=== Response ===");
        this.debug(true, "Response message: " + connection.getResponseMessage());
        this.debug(true, "Response headers:");
        connection.getHeaderFields().forEach((key, value1) -> {
            for (String value : value1) {
                this.debug(true, "  " + key + ": " + value);
            }
        });
        this.debug(true, "Response data: " + responseBody);
    }

    public void debug(boolean verbose, String string) {
        if (verbose) {
            this.ctx.out().println(string);
        }
    }
}

