/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.UploadCommand;

public final class IOCommon {
    private IOCommon() {
    }

    public static URL safeUrl(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL '" + urlString + "'", e);
        }
    }

    public static String base64Encode(String username, char[] password) {
        String plainToken = username + ":" + String.valueOf(password);
        return Base64.getEncoder().encodeToString(plainToken.getBytes());
    }

    public static <T> T parseJsonUsingJacksonParser(String json, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(json, type);
    }

    public static String SerializeWithJackson(Object pojo) throws IOException {
        return new ObjectMapper().writeValueAsString(pojo);
    }

    public static void safeSkip(InputStream sourceStream, long position) throws IOException {
        for (long toSkip = position; toSkip > 0L; toSkip -= sourceStream.skip(position)) {
        }
    }

    public static long getFileSize(UploadCommand.Source src, ExecutionContext ctx) {
        long fileSize;
        try {
            fileSize = src.fs().getFileSize(src.path());
        }
        catch (IOException e) {
            ctx.err().println(String.format("Failed to determine size of file at location: %s", src.path()));
            throw new CommandFailedException(e.getMessage());
        }
        return fileSize;
    }

    @FunctionalInterface
    public static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }
}

