/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.providers;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.compress.utils.IOUtils;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.CommandResponseHandler;
import org.neo4j.export.UploadCommand;
import org.neo4j.export.providers.SignedUpload;
import org.neo4j.export.providers.SignedUploadURLFactory;
import org.neo4j.export.util.IOCommon;
import org.neo4j.export.util.ProgressTrackingOutputStream;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SignedUploadGCP
implements SignedUpload {
    static final int HTTP_RESUME_INCOMPLETE = 308;
    private static final long POSITION_UPLOAD_COMPLETED = -1L;
    private static final long DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS = TimeUnit.SECONDS.toMillis(64L);
    private static final long DEFAULT_MAXIMUM_RETRIES = 50L;
    private static final String UPLOAD_RESPONSE_ERROR_MESSAGE = "Encountered unexpected response uploading to storage";
    String[] signedLinks;
    String signedURI;
    ExecutionContext ctx;
    ProgressListenerFactory progressListenerFactory = (text, length) -> ProgressMonitorFactory.textual((OutputStream)this.ctx.out()).singlePart(text, length);
    Sleeper sleeper;
    String boltURI;
    private final CommandResponseHandler commandResponseHandler;

    public SignedUploadGCP(String[] signedLinks, String signedURI, ExecutionContext ctx, String boltURI, CommandResponseHandler commandResponseHandler) {
        this.signedLinks = signedLinks;
        this.signedURI = signedURI;
        this.ctx = ctx;
        this.boltURI = boltURI;
        this.sleeper = Thread::sleep;
        this.commandResponseHandler = commandResponseHandler;
    }

    public SignedUploadGCP(String[] signedLinks, String signedURI, ExecutionContext ctx, String boltURI, ProgressListenerFactory progressListenerFactory, Sleeper sleeper, CommandResponseHandler commandResponseHandler) {
        this.signedLinks = signedLinks;
        this.signedURI = signedURI;
        this.ctx = ctx;
        this.boltURI = boltURI;
        this.progressListenerFactory = progressListenerFactory;
        this.sleeper = sleeper;
        this.commandResponseHandler = commandResponseHandler;
    }

    private static long parseResumablePosition(String range) {
        int dashIndex = range.indexOf(45);
        if (!range.startsWith("bytes=") || dashIndex == -1) {
            throw new CommandFailedException("Unexpected response when asking where to resume upload from. got '" + range + "'");
        }
        return Long.parseLong(range.substring(dashIndex + 1)) + 1L;
    }

    private URL initiateResumableUpload(boolean verbose) throws IOException {
        URL signedURL = this.getCorrectVersionedEndpoint();
        HttpURLConnection connection = (HttpURLConnection)signedURL.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Length", "0");
            connection.setFixedLengthStreamingMode(0);
            connection.setRequestProperty("x-goog-resumable", "start");
            connection.setRequestProperty("Content-Type", "");
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 201: {
                    URL uRL = IOCommon.safeUrl(connection.getHeaderField("Location"));
                    return uRL;
                }
                case 502: 
                case 503: 
                case 504: {
                    throw new SignedUploadURLFactory.RetryableHttpException(this.commandResponseHandler.unexpectedResponse(verbose, connection, "Initiating database upload"));
                }
            }
            throw this.commandResponseHandler.unexpectedResponse(verbose, connection, "Initiating database upload");
        }
    }

    @Override
    public void copy(boolean verbose, UploadCommand.Source source) {
        URL dest;
        try {
            dest = this.initiateResumableUpload(verbose);
        }
        catch (IOException e) {
            this.ctx.err().println("Failed to initiate a resumable upload");
            throw new CommandFailedException("Failed to initiate resumable upload", (Throwable)e);
        }
        this.transfer(verbose, source, dest);
    }

    public URL getCorrectVersionedEndpoint() {
        URL dest = this.signedLinks != null && this.signedLinks.length > 0 ? IOCommon.safeUrl(this.signedLinks[0]) : IOCommon.safeUrl(this.signedURI);
        return dest;
    }

    private void transfer(boolean verbose, UploadCommand.Source source, URL dest) {
        try {
            long sourceLength = this.ctx.fs().getFileSize(source.path());
            long position = 0L;
            int resumeUploadRetries = 0;
            this.commandResponseHandler.debug(verbose, "copying to URL: " + String.valueOf(dest));
            ThreadLocalRandom random = ThreadLocalRandom.current();
            ProgressTrackingOutputStream.Progress uploadProgress = new ProgressTrackingOutputStream.Progress(this.progressListenerFactory.create("Upload", sourceLength), position);
            while (!this.resumeUpload(verbose, source.path(), sourceLength, position, dest, uploadProgress)) {
                this.commandResponseHandler.debug(verbose, "Getting resume position");
                position = this.getResumablePosition(verbose, sourceLength, dest);
                if (position == -1L) break;
                if ((long)resumeUploadRetries > 50L) {
                    throw new CommandFailedException("Upload failed after numerous attempts.");
                }
                long backoffFromRetryCount = TimeUnit.SECONDS.toMillis(1L << resumeUploadRetries++) + (long)random.nextInt(1000);
                this.sleeper.sleep(Long.min(backoffFromRetryCount, DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS));
            }
            this.ctx.out().println("Upload completed successfully\n");
            uploadProgress.done();
        }
        catch (IOException | InterruptedException e) {
            this.ctx.out().println("Failed to upload database" + String.valueOf(e.getCause()));
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private CommandFailedException resumePossibleErrorResponse(HttpURLConnection connection, Path dump) throws IOException {
        this.commandResponseHandler.debugErrorResponse(true, connection);
        return new CommandFailedException("We encountered a problem while communicating to the Neo4j Aura system. \nYou can re-try using the existing dump by running this command: \n" + String.format("neo4j-admin database upload --%s=%s --%s=%s", "dump", dump.getParent(), "bolt-uri", this.boltURI));
    }

    private boolean resumeUpload(boolean verbose, Path source, long sourceLength, long position, URL uploadLocation, ProgressTrackingOutputStream.Progress uploadProgress) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uploadLocation.openConnection();
        try (Closeable c = connection::disconnect;){
            connection.setRequestMethod("PUT");
            long contentLength = sourceLength - position;
            connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            connection.setFixedLengthStreamingMode(contentLength);
            if (position > 0L) {
                connection.setRequestProperty("Content-Range", String.format("bytes %d-%d/%d", position, sourceLength - 1L, sourceLength));
                this.commandResponseHandler.debug(true, "resume upload from " + position + " to " + (sourceLength - 1L) + " of " + sourceLength + " bytes");
            }
            connection.setDoOutput(true);
            uploadProgress.rewindTo(position);
            try (InputStream sourceStream = Files.newInputStream(source, new OpenOption[0]);
                 OutputStream targetStream = connection.getOutputStream();){
                IOCommon.safeSkip(sourceStream, position);
                org.apache.commons.io.IOUtils.copy((InputStream)new BufferedInputStream(sourceStream), (OutputStream)new ProgressTrackingOutputStream(targetStream, uploadProgress));
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 403: {
                    if (this.canSkipToImport(connection.getErrorStream())) {
                        boolean bl = true;
                        return bl;
                    }
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    this.commandResponseHandler.debugErrorResponse(verbose, connection);
                    boolean bl = false;
                    return bl;
                }
            }
            this.commandResponseHandler.debug(true, "resume upload ends\n");
            throw this.resumePossibleErrorResponse(connection, source);
        }
    }

    public boolean canSkipToImport(InputStream errorStream) throws IOException {
        String responseString = new String(IOUtils.toByteArray((InputStream)errorStream), StandardCharsets.UTF_8);
        try {
            boolean valid;
            String details;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setXIncludeAware(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(responseString)));
            document.getDocumentElement().normalize();
            Node codeNode = document.getElementsByTagName("Code").item(0);
            Node detailsNode = document.getElementsByTagName("Details").item(0);
            if (this.handleNullResponse(codeNode, detailsNode)) {
                return false;
            }
            String code = codeNode.getTextContent();
            if (this.handleNullResponse(code, details = detailsNode.getTextContent())) {
                return false;
            }
            String objectExistsText = "does not have storage.objects.delete access to the Google Cloud Storage object.";
            boolean bl = valid = details.contains(objectExistsText) && code.equals("AccessDenied");
            if (!valid) {
                this.ctx.out().println(UPLOAD_RESPONSE_ERROR_MESSAGE);
                return false;
            }
            this.ctx.out().println("Detected already uploaded object, proceeding to import");
            return true;
        }
        catch (ParserConfigurationException | DOMException | SAXException e) {
            throw new IOException("Encountered invalid response from cloud import location", e.getCause());
        }
    }

    private boolean handleNullResponse(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            this.ctx.out().println(UPLOAD_RESPONSE_ERROR_MESSAGE);
            return true;
        }
        return false;
    }

    private long getResumablePosition(boolean verbose, long sourceLength, URL uploadLocation) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uploadLocation.openConnection();
        try (Closeable c = connection::disconnect;){
            this.commandResponseHandler.debug(verbose, "Asking about resumable position for the upload");
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Length", "0");
            connection.setFixedLengthStreamingMode(0);
            connection.setRequestProperty("Content-Range", "bytes */" + sourceLength);
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 201: {
                    this.commandResponseHandler.debug(verbose, "Upload seems to be completed got " + responseCode);
                    long l = -1L;
                    return l;
                }
                case 502: 
                case 503: 
                case 504: {
                    throw new SignedUploadURLFactory.RetryableHttpException(this.commandResponseHandler.unexpectedResponse(verbose, connection, "Acquire resumable upload position"));
                }
                case 308: {
                    String range = connection.getHeaderField("Range");
                    this.commandResponseHandler.debug(verbose, "Upload not completed got " + range);
                    long position = range == null ? 0L : SignedUploadGCP.parseResumablePosition(range);
                    this.commandResponseHandler.debug(verbose, "Parsed that as position " + position);
                    long l = position;
                    return l;
                }
            }
            throw this.commandResponseHandler.unexpectedResponse(verbose, connection, "Acquire resumable upload position");
        }
    }

    public static interface ProgressListenerFactory {
        public ProgressListener create(String var1, long var2);
    }

    public static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }
}

