/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.procedure.builtin;

import static java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME;
import static java.util.concurrent.TimeUnit.HOURS;
import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static java.util.concurrent.TimeUnit.MINUTES;
import static java.util.concurrent.TimeUnit.SECONDS;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public class ProceduresTimeFormatHelper {
    public static String formatTime(final Instant instant, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(instant, zoneId).format(ISO_OFFSET_DATE_TIME);
    }

    public static String formatTime(final long startTime, ZoneId zoneId) {
        return formatTime(Instant.ofEpochMilli(startTime), zoneId);
    }

    public static String formatInterval(final long l) {
        final long hr = MILLISECONDS.toHours(l);
        final long min = MILLISECONDS.toMinutes(l - HOURS.toMillis(hr));
        final long sec = MILLISECONDS.toSeconds(l - HOURS.toMillis(hr) - MINUTES.toMillis(min));
        final long ms = l - HOURS.toMillis(hr) - MINUTES.toMillis(min) - SECONDS.toMillis(sec);
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }
}
