/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;
import org.neo4j.values.AnyValue;

public abstract class BaseStreamIterator
implements ResourceRawIterator<AnyValue[], ProcedureException> {
    private final Iterator<?> out;
    private Stream<?> stream;
    private final ResourceMonitor resourceMonitor;
    private final ProcedureSignature signature;

    public BaseStreamIterator(Stream<?> stream, ResourceMonitor resourceMonitor, ProcedureSignature signature) {
        this.out = stream.iterator();
        this.stream = stream;
        this.resourceMonitor = resourceMonitor;
        this.signature = signature;
        resourceMonitor.registerCloseableResource(stream);
    }

    public abstract AnyValue[] map(Object var1);

    public boolean hasNext() throws ProcedureException {
        try {
            boolean hasNext = this.out.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }
        catch (Throwable throwable) {
            throw this.closeAndCreateProcedureException(throwable);
        }
    }

    public AnyValue[] next() throws ProcedureException {
        try {
            Object record = this.out.next();
            return this.map(record);
        }
        catch (Throwable throwable) {
            throw this.closeAndCreateProcedureException(throwable);
        }
    }

    public void close() {
        if (this.stream != null) {
            Stream<?> resourceToClose = this.stream;
            this.stream = null;
            IOUtils.close(ResourceCloseFailureException::new, (AutoCloseable[])new AutoCloseable[]{() -> this.resourceMonitor.unregisterCloseableResource(resourceToClose), resourceToClose});
        }
    }

    private ProcedureException closeAndCreateProcedureException(Throwable t) {
        ProcedureException procedureException = this.newProcedureException(t);
        try {
            this.close();
        }
        catch (Exception exceptionDuringClose) {
            try {
                procedureException.addSuppressed((Throwable)exceptionDuringClose);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return procedureException;
    }

    private ProcedureException newProcedureException(Throwable throwable) {
        return ProcedureException.innerExceptionFailed((Throwable)throwable, (ProcedureSignature)this.signature);
    }
}

