/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.procedure.Description;

public class ConfigResult {
    @Description(value="The name of the setting.")
    public final String name;
    @Description(value="The description of the setting.")
    public final String description;
    @Description(value="The set value of the setting.")
    public final String value;
    @Description(value="If the setting can be set dynamically or not.")
    public final boolean dynamic;
    @Description(value="The default value of the setting.")
    public final String defaultValue;
    @Description(value="The value of the setting when the database started.")
    public final String startupValue;
    @Description(value="Whether or not the setting was explicitly set.")
    public final boolean explicitlySet;
    @Description(value="A description of the valid values.")
    public final String validValues;

    public ConfigResult(Setting<Object> setting, Config config) {
        SettingImpl settingImpl = (SettingImpl)setting;
        this.name = setting.name();
        this.description = setting.description();
        this.value = settingImpl.valueToString(config.get(setting));
        this.dynamic = setting.dynamic();
        this.defaultValue = settingImpl.valueToString(config.getDefault(setting));
        this.startupValue = settingImpl.valueToString(config.getStartupValue(setting));
        this.explicitlySet = config.isExplicitlySet(setting);
        this.validValues = settingImpl.validValues();
    }
}

