/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Sensitive;
import org.neo4j.procedure.impl.Cypher5TypeCheckers;

class MethodSignatureCompiler {
    private final Cypher5TypeCheckers typeCheckers;

    MethodSignatureCompiler(Cypher5TypeCheckers typeCheckers) {
        this.typeCheckers = typeCheckers;
    }

    List<FieldSignature> signatureFor(Method method) throws ProcedureException {
        Parameter[] params = method.getParameters();
        Type[] types = method.getGenericParameterTypes();
        ArrayList<FieldSignature> signature = new ArrayList<FieldSignature>(params.length);
        boolean seenDefault = false;
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            Type type = types[i];
            if (!param.isAnnotationPresent(Name.class)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is missing an `@%s` annotation.%nPlease add the annotation, recompile the class and try again.", new Object[]{i, method.getName(), Name.class.getSimpleName()});
            }
            Name parameter = param.getAnnotation(Name.class);
            String name = parameter.value();
            String description = parameter.description();
            if (name.isBlank()) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is annotated with a name,%nbut the name is empty, please provide a non-empty name for the argument.", new Object[]{i, method.getName()});
            }
            try {
                Cypher5TypeCheckers.DefaultValueConverter valueConverter = this.typeCheckers.converterFor(type);
                Optional<DefaultParameterValue> defaultValue = valueConverter.defaultValue(parameter.defaultValue());
                if (seenDefault && !defaultValue.isPresent()) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Non-default argument at position %d with name %s in method %s follows default argument. Add a default value or rearrange arguments so that the non-default values comes first.", new Object[]{i, parameter.value(), method.getName()});
                }
                seenDefault = defaultValue.isPresent();
                boolean isSensitive = param.isAnnotationPresent(Sensitive.class);
                boolean isDeprecated = param.isAnnotationPresent(Deprecated.class);
                signature.add(defaultValue.map(neo4jValue -> FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)valueConverter.type(), (DefaultParameterValue)neo4jValue, (boolean)isDeprecated, (boolean)isSensitive, (String)description)).orElseGet(() -> FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)valueConverter.type(), (boolean)isDeprecated, (boolean)isSensitive, (String)description)));
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), "Argument `%s` at position %d in `%s` with%ntype `%s` cannot be converted to a Neo4j type: %s", new Object[]{name, i, method.getName(), param.getType().getSimpleName(), e.getMessage()});
            }
        }
        return signature;
    }
}

