/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.neo4j.exceptions.KernelException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.logging.InternalLog;
import org.neo4j.procedure.impl.NamingRestrictions;
import org.neo4j.procedure.impl.ProcedureClassLoader;
import org.neo4j.procedure.impl.ProcedureCompiler;
import org.neo4j.string.Globbing;

class ProcedureJarLoader
implements AutoCloseable {
    private final ProcedureCompiler compiler;
    private final InternalLog log;
    private final boolean reloadProceduresFromDisk;
    private final Set<Closeable> closeables = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    ProcedureJarLoader(ProcedureCompiler compiler, InternalLog log, boolean reloadProceduresFromDisk) {
        this.compiler = compiler;
        this.log = log;
        this.reloadProceduresFromDisk = reloadProceduresFromDisk;
    }

    Callables loadProceduresFromDir(Path root) throws IOException, KernelException {
        return this.loadProceduresFromDir(root, Globbing.MATCH_ALL);
    }

    Callables loadProceduresFromDir(Path root, Predicate<String> methodNameFilter) throws IOException, KernelException {
        if (root == null || Files.notExists(root, new LinkOption[0])) {
            return Callables.empty();
        }
        ArrayList<Path> jarFiles = new ArrayList<Path>();
        try (DirectoryStream<Path> list = Files.newDirectoryStream(root, "*.jar");){
            for (Path pth : list) {
                jarFiles.add(pth);
            }
        }
        if (jarFiles.isEmpty()) {
            return Callables.empty();
        }
        ProcedureClassLoader.Result result = ProcedureClassLoader.setup(jarFiles, this.log, this.reloadProceduresFromDisk);
        ProcedureClassLoader loader = result.loader();
        this.closeables.add(loader);
        Callables out = new Callables();
        for (ProcedureClassLoader.Entry entry : result.loadedClasses()) {
            try {
                List<CallableProcedure> procedures = this.compiler.compileProcedure(entry.cls(), false, loader, methodNameFilter);
                List<CallableUserFunction> functions = this.compiler.compileFunction(entry.cls(), false, loader, methodNameFilter);
                List<CallableUserAggregationFunction> aggregations = this.compiler.compileAggregationFunction(entry.cls(), loader, methodNameFilter);
                out.addAllProcedures(procedures);
                out.addAllFunctions(functions);
                out.addAllAggregationFunctions(aggregations);
            }
            catch (NamingRestrictions.IllegalNamingException exc) {
                this.log.error("Failed to load procedures from class %s in %s/%s: %s", new Object[]{entry.cls().getSimpleName(), entry.jar().getParent().getFileName(), entry.jar().getFileName(), exc.getMessage()});
            }
        }
        return out;
    }

    @Override
    public void close() throws Exception {
        try {
            IOUtils.closeAll(this.closeables);
        }
        finally {
            this.closeables.clear();
        }
    }

    public static class Callables {
        private final List<CallableProcedure> procedures = new ArrayList<CallableProcedure>();
        private final List<CallableUserFunction> functions = new ArrayList<CallableUserFunction>();
        private final List<CallableUserAggregationFunction> aggregationFunctions = new ArrayList<CallableUserAggregationFunction>();
        private static final Callables EMPTY = new Callables();

        public void add(CallableProcedure proc) {
            this.procedures.add(proc);
        }

        public void add(CallableUserFunction func) {
            this.functions.add(func);
        }

        public List<CallableProcedure> procedures() {
            return this.procedures;
        }

        public List<CallableUserFunction> functions() {
            return this.functions;
        }

        public List<CallableUserAggregationFunction> aggregationFunctions() {
            return this.aggregationFunctions;
        }

        void addAllProcedures(List<CallableProcedure> callableProcedures) {
            this.procedures.addAll(callableProcedures);
        }

        void addAllFunctions(List<CallableUserFunction> callableFunctions) {
            this.functions.addAll(callableFunctions);
        }

        void addAllAggregationFunctions(List<CallableUserAggregationFunction> callableFunctions) {
            this.aggregationFunctions.addAll(callableFunctions);
        }

        public static Callables empty() {
            return EMPTY;
        }
    }
}

