/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.graphschema;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.cypher.internal.util.UnicodeHelper;

final class SchemaNames {
    private static final String ESCAPED_UNICODE_BACKTICK = "\\u0060";
    private static final Pattern PATTERN_ESCAPED_4DIGIT_UNICODE = Pattern.compile("\\\\u+(\\p{XDigit}{4})");
    private static final Pattern PATTERN_LABEL_AND_TYPE_QUOTATION = Pattern.compile("(?<!`)`(?:`{2})*(?!`)");
    private static final List<String[]> SUPPORTED_ESCAPE_CHARS = List.of(new String[]{"\\b", "\b"}, new String[]{"\\f", "\f"}, new String[]{"\\n", "\n"}, new String[]{"\\r", "\r"}, new String[]{"\\t", "\t"}, new String[]{"\\`", "``"});
    private static final int CACHE_SIZE = 128;
    private static final Map<String, SchemaName> CACHE = Collections.synchronizedMap(new LinkedHashMap<String, SchemaName>(32, 0.75f, true){
        private static final long serialVersionUID = -8109893585632797360L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SchemaName> eldest) {
            return this.size() >= 128;
        }
    });

    public static Optional<String> sanitize(String value) {
        return SchemaNames.sanitize(value, false);
    }

    public static Optional<String> sanitize(String value, boolean enforceQuotes) {
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        SchemaName escapedValue = CACHE.computeIfAbsent(value, SchemaNames::sanitize0);
        if (!enforceQuotes && !escapedValue.needsQuotation) {
            return Optional.of(escapedValue.value);
        }
        return Optional.of(String.format(Locale.ENGLISH, "`%s`", escapedValue.value));
    }

    private static SchemaName sanitize0(String key) {
        String workingValue = key;
        for (String[] pair : SUPPORTED_ESCAPE_CHARS) {
            workingValue = workingValue.replace(pair[0], pair[1]);
        }
        workingValue = workingValue.replace(ESCAPED_UNICODE_BACKTICK, "`");
        Matcher matcher = PATTERN_ESCAPED_4DIGIT_UNICODE.matcher(workingValue);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String replacement = Character.toString((char)Integer.parseInt(matcher.group(1), 16));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        workingValue = sb.toString();
        workingValue = workingValue.replace("\\u", "\\u005C\\u0075");
        matcher = PATTERN_LABEL_AND_TYPE_QUOTATION.matcher(workingValue);
        workingValue = matcher.replaceAll("`$0").replace("\\\\", "\\");
        return new SchemaName(workingValue, !SchemaNames.isIdentifier(workingValue));
    }

    private static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        int cp = id.codePointAt(0);
        if (!UnicodeHelper.isIdentifierStart((Integer)cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (UnicodeHelper.isIdentifierPart((Integer)cp)) continue;
            return false;
        }
        return true;
    }

    private SchemaNames() {
    }

    private record SchemaName(String value, boolean needsQuotation) {
    }
}

