/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.procedure.impl.ProcedureHolder;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;

public class ProcedureRegistry {
    private final ProcedureHolder<CallableProcedure> procedures;
    private final ProcedureHolder<CallableUserFunction> functions;
    private final ProcedureHolder<CallableUserAggregationFunction> aggregationFunctions;

    public ProcedureRegistry() {
        this(new ProcedureHolder<CallableProcedure>(), new ProcedureHolder<CallableUserFunction>(), new ProcedureHolder<CallableUserAggregationFunction>());
    }

    private ProcedureRegistry(ProcedureHolder<CallableProcedure> procedures, ProcedureHolder<CallableUserFunction> functions, ProcedureHolder<CallableUserAggregationFunction> aggregationFunctions) {
        this.procedures = procedures;
        this.functions = functions;
        this.aggregationFunctions = aggregationFunctions;
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        ProcedureSignature signature = proc.signature();
        QualifiedName name = signature.name();
        String descriptiveName = signature.toString();
        this.validateSignature(descriptiveName, signature.inputSignature(), "input");
        this.validateSignature(descriptiveName, signature.outputSignature(), "output");
        if (!signature.isVoid() && signature.outputSignature().isEmpty()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedures with zero output fields must be declared as VOID", new Object[0]);
        }
        if (this.procedures.contains(name)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register procedure, because the name `%s` is already in use.", new Object[]{name});
        }
        this.procedures.put(name, proc, signature.caseInsensitive());
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        if (this.aggregationFunctions.contains(name)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use as an aggregation function.", new Object[]{name});
        }
        if (this.functions.contains(name)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use.", new Object[]{name});
        }
        this.functions.put(name, function, signature.caseInsensitive());
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        if (this.functions.contains(name)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use as a function.", new Object[]{name});
        }
        if (this.aggregationFunctions.contains(name)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use.", new Object[]{name});
        }
        this.aggregationFunctions.put(name, function, signature.caseInsensitive());
    }

    private void validateSignature(String descriptiveName, List<FieldSignature> fields, String fieldType) throws ProcedureException {
        HashSet<String> names = new HashSet<String>();
        for (FieldSignature field : fields) {
            if (names.add(field.name())) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedure `%s` cannot be registered, because it contains a duplicated " + fieldType + " field, '%s'. You need to rename or remove one of the duplicate fields.", new Object[]{descriptiveName, field.name()});
        }
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        CallableProcedure proc = this.procedures.get(name);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return new ProcedureHandle(proc.signature(), this.procedures.idOf(name));
    }

    public UserFunctionHandle function(QualifiedName name) {
        CallableUserFunction func = this.functions.get(name);
        if (func == null) {
            return null;
        }
        return new UserFunctionHandle(func.signature(), this.functions.idOf(name));
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        CallableUserAggregationFunction func = this.aggregationFunctions.get(name);
        if (func == null) {
            return null;
        }
        return new UserFunctionHandle(func.signature(), this.aggregationFunctions.idOf(name));
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        CallableProcedure proc;
        try {
            proc = this.procedures.get(id);
            PermissionState permission = ctx.securityContext().allowExecuteAdminProcedure(id);
            if (proc.signature().admin() && !permission.allowsAccess()) {
                String errorDescriptor = permission == PermissionState.EXPLICIT_DENY ? "is not allowed" : "permission has not been granted";
                String message = String.format("Executing admin procedure '%s' %s for %s.", proc.signature().name(), errorDescriptor, ctx.securityContext().description());
                ((AbstractSecurityLog)ctx.dependencyResolver().resolveDependency(AbstractSecurityLog.class)).error(ctx.securityContext(), message);
                throw new AuthorizationViolationException(message);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchProcedure(id);
        }
        return proc.apply(ctx, input, resourceMonitor);
    }

    public AnyValue callFunction(Context ctx, int functionId, AnyValue[] input) throws ProcedureException {
        CallableUserFunction func;
        try {
            func = this.functions.get(functionId);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchFunction(functionId);
        }
        return func.apply(ctx, input);
    }

    public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
        try {
            CallableUserAggregationFunction func = this.aggregationFunctions.get(id);
            return func.createReducer(ctx);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchFunction(id);
        }
    }

    private ProcedureException noSuchProcedure(QualifiedName name) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", new Object[]{name});
    }

    private ProcedureException noSuchProcedure(int id) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the internal id `%d` registered for this database instance.", new Object[]{id});
    }

    private ProcedureException noSuchFunction(int id) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no function with the internal id `%d` registered for this database instance.", new Object[]{id});
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.procedures.all().stream().map(CallableProcedure::signature).collect(Collectors.toSet());
    }

    int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
        int[] ids = new int[10];
        int count = 0;
        for (CallableProcedure p : this.procedures.all()) {
            if (!predicate.test(p)) continue;
            int i = this.procedures.idOf(p.signature().name());
            if (ids.length == count) {
                ids = Arrays.copyOf(ids, count * 2);
            }
            ids[count++] = i;
        }
        ids = Arrays.copyOfRange(ids, 0, count);
        return ids;
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
        return this.functions.all().stream().map(CallableUserFunction::signature);
    }

    int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
        int[] ids = new int[10];
        int count = 0;
        for (CallableUserFunction f : this.functions.all()) {
            if (!predicate.test(f)) continue;
            int i = this.functions.idOf(f.signature().name());
            if (ids.length == count) {
                ids = Arrays.copyOf(ids, count * 2);
            }
            ids[count++] = i;
        }
        ids = Arrays.copyOfRange(ids, 0, count);
        return ids;
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
        return this.aggregationFunctions.all().stream().map(CallableUserAggregationFunction::signature);
    }

    int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
        int[] ids = new int[10];
        int count = 0;
        for (CallableUserAggregationFunction f : this.aggregationFunctions.all()) {
            if (!predicate.test(f)) continue;
            int i = this.aggregationFunctions.idOf(f.signature().name());
            if (ids.length == count) {
                ids = Arrays.copyOf(ids, count * 2);
            }
            ids[count++] = i;
        }
        ids = Arrays.copyOfRange(ids, 0, count);
        return ids;
    }

    @VisibleForTesting
    public void unregister(QualifiedName name) {
        this.procedures.unregister(name);
        this.functions.unregister(name);
        this.aggregationFunctions.unregister(name);
    }

    public static ProcedureRegistry copyOf(ProcedureRegistry ref) {
        return new ProcedureRegistry(ProcedureHolder.copyOf(ref.procedures), ProcedureHolder.copyOf(ref.functions), ProcedureHolder.copyOf(ref.aggregationFunctions));
    }
}

