/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.builtin.routing.BaseRoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.ClientSideRoutingTableProvider;
import org.neo4j.procedure.builtin.routing.InstanceClusterView;
import org.neo4j.procedure.builtin.routing.ParameterNames;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.procedure.builtin.routing.RoutingResultFormat;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureHelpers;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.ServerSideRoutingTableProvider;
import org.neo4j.procedure.builtin.routing.SingleAddressRoutingTableProvider;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class GetRoutingTableProcedure
implements CallableProcedure {
    private static final String NAME = "getRoutingTable";
    private static final String DESCRIPTION = "Returns the advertised bolt capable endpoints for a given database, divided by each endpoint's capabilities. For example an endpoint may serve read queries, write queries and/or future getRoutingTable requests.";
    public static final String ADDRESS_CONTEXT_KEY = "address";
    private final ProcedureSignature signature;
    private final DatabaseReferenceRepository databaseReferenceRepo;
    private final InternalLog log;
    private final RoutingTableProcedureValidator validator;
    private final ClientSideRoutingTableProvider clientSideRoutingTableProvider;
    private final ServerSideRoutingTableProvider serverSideRoutingTableProvider;
    private final ClientRoutingDomainChecker clientRoutingDomainChecker;
    private final Supplier<GraphDatabaseSettings.RoutingMode> defaultRouterSupplier;
    private final Supplier<Boolean> boltEnabled;
    private final InstanceClusterView instanceClusterView;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final String defaultDbFromConfig;

    public GetRoutingTableProcedure(List<String> namespace, DatabaseReferenceRepository databaseReferenceRepo, RoutingTableProcedureValidator validator, SingleAddressRoutingTableProvider routingTableProvider, ClientRoutingDomainChecker clientRoutingDomainChecker, Config config, InternalLogProvider logProvider, InstanceClusterView instanceClusterView, DefaultDatabaseResolver defaultDatabaseResolver) {
        this(namespace, databaseReferenceRepo, validator, routingTableProvider, routingTableProvider, clientRoutingDomainChecker, config, logProvider, instanceClusterView, defaultDatabaseResolver);
    }

    public GetRoutingTableProcedure(List<String> namespace, DatabaseReferenceRepository databaseReferenceRepo, RoutingTableProcedureValidator validator, ClientSideRoutingTableProvider clientSideRoutingTableProvider, ServerSideRoutingTableProvider serverSideRoutingTableProvider, ClientRoutingDomainChecker clientRoutingDomainChecker, Config config, InternalLogProvider logProvider, InstanceClusterView instanceClusterView, DefaultDatabaseResolver defaultDatabaseResolver) {
        this.signature = GetRoutingTableProcedure.buildSignature(namespace, DESCRIPTION);
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.log = logProvider.getLog(this.getClass());
        this.validator = validator;
        this.clientSideRoutingTableProvider = clientSideRoutingTableProvider;
        this.serverSideRoutingTableProvider = serverSideRoutingTableProvider;
        this.clientRoutingDomainChecker = clientRoutingDomainChecker;
        this.defaultRouterSupplier = () -> (GraphDatabaseSettings.RoutingMode)config.get(GraphDatabaseSettings.routing_default_router);
        this.instanceClusterView = instanceClusterView;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.defaultDbFromConfig = (String)config.get(GraphDatabaseSettings.initial_default_database);
        this.boltEnabled = () -> (Boolean)config.get(BoltConnector.enabled);
    }

    public ProcedureSignature signature() {
        return this.signature;
    }

    public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
        String user = ctx.securityContext().subject().executingUser();
        DatabaseReference databaseReference = this.extractDatabaseReference(input, user);
        MapValue routingContext = GetRoutingTableProcedure.extractRoutingContext(input);
        this.assertBoltConnectorEnabled(databaseReference);
        try {
            RoutingResult result = this.invoke(databaseReference, routingContext);
            this.log.info("Routing result for database %s and routing context %s is %s", new Object[]{databaseReference, routingContext, result});
            GetRoutingTableProcedure.assertRoutingResultNotEmpty(result, databaseReference);
            return RawIterator.of((Object[])new AnyValue[][]{RoutingResultFormat.build(result)});
        }
        catch (ProcedureException ex) {
            this.validator.assertDatabaseExists(databaseReference);
            throw ex;
        }
    }

    private RoutingResult invoke(DatabaseReference databaseReference, MapValue routingContext) throws ProcedureException {
        Optional<SocketAddress> clientProvidedAddress = RoutingTableProcedureHelpers.findClientProvidedAddress(routingContext, 7687, this.log);
        boolean isInternalRef = databaseReference instanceof DatabaseReference.Internal;
        if (!isInternalRef) {
            return this.serverSideRoutingTableProvider.getServerSideRoutingTable(routingContext);
        }
        GraphDatabaseSettings.RoutingMode defaultRouter = this.defaultRouterSupplier.get();
        if (this.configAllowsForClientSideRouting(defaultRouter, clientProvidedAddress)) {
            this.validator.isValidForClientSideRouting((DatabaseReference.Internal)databaseReference);
            return this.clientSideRoutingTableProvider.getRoutingResultForClientSideRouting((DatabaseReference.Internal)databaseReference, routingContext);
        }
        this.validator.isValidForServerSideRouting((DatabaseReference.Internal)databaseReference);
        return this.serverSideRoutingTableProvider.getServerSideRoutingTable(routingContext);
    }

    private DatabaseReference extractDatabaseReference(AnyValue[] input, String user) throws ProcedureException {
        String databaseName;
        AnyValue arg = input[1];
        if (arg == Values.NO_VALUE) {
            databaseName = this.defaultDatabaseResolver.defaultDatabase(user);
        } else if (arg instanceof TextValue) {
            databaseName = ((TextValue)arg).stringValue();
        } else {
            throw new IllegalArgumentException("Illegal database name argument " + arg);
        }
        return (DatabaseReference)this.databaseReferenceRepo.getByAlias(databaseName).orElseThrow(() -> BaseRoutingTableProcedureValidator.databaseNotFoundException(databaseName));
    }

    private static void assertRoutingResultNotEmpty(RoutingResult result, DatabaseReference databaseReference) throws ProcedureException {
        if (result.containsNoEndpoints()) {
            throw new ProcedureException((Status)Status.General.DatabaseUnavailable, "Routing table for database " + databaseReference.alias() + " is empty", new Object[0]);
        }
    }

    private static MapValue extractRoutingContext(AnyValue[] input) {
        AnyValue arg = input[0];
        if (arg == Values.NO_VALUE) {
            return MapValue.EMPTY;
        }
        if (arg instanceof MapValue) {
            return (MapValue)arg;
        }
        throw new IllegalArgumentException("Illegal routing context argument " + arg);
    }

    private static ProcedureSignature buildSignature(List<String> namespace, String description) {
        return ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(namespace, NAME)).in(ParameterNames.CONTEXT.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTMap).in(ParameterNames.DATABASE.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTString, DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.SERVERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).mode(Mode.DBMS).description(description).systemProcedure().allowExpiredCredentials().build();
    }

    private boolean configAllowsForClientSideRouting(GraphDatabaseSettings.RoutingMode defaultRouter, Optional<SocketAddress> clientProvidedAddress) {
        if (this.instanceClusterView.amIAlone()) {
            return false;
        }
        switch (defaultRouter) {
            case CLIENT: {
                return true;
            }
            case SERVER: {
                return clientProvidedAddress.isEmpty() || this.clientRoutingDomainChecker.shouldGetClientRouting(clientProvidedAddress.get());
            }
        }
        throw new IllegalStateException("Unexpected value: " + defaultRouter);
    }

    private void assertBoltConnectorEnabled(DatabaseReference databaseReference) throws ProcedureException {
        if (!this.boltEnabled.get().booleanValue()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Cannot get routing table for " + databaseReference.alias() + " because Bolt is not enabled. Please update your configuration for '" + BoltConnector.enabled.name() + "'", new Object[0]);
        }
    }
}

