/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.procedure.builtin.routing.DatabaseAvailabilityChecker;

public final class DefaultDatabaseAvailabilityChecker
implements DatabaseAvailabilityChecker {
    private final DatabaseContextProvider<?> databaseContextProvider;

    public DefaultDatabaseAvailabilityChecker(DatabaseContextProvider<?> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    @Override
    public boolean isAvailable(DatabaseReference.Internal databaseReference) {
        Optional databaseCtx = this.databaseContextProvider.getDatabaseContext(databaseReference.databaseId());
        return databaseCtx.map(ctx -> ctx.database().getDatabaseAvailabilityGuard().isAvailable()).orElse(false);
    }

    @Override
    public boolean isPresent(DatabaseReference.Internal databaseReference) {
        return this.databaseContextProvider.getDatabaseContext(databaseReference.databaseId()).isPresent();
    }
}

