/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.procedure.builtin.routing.BaseRoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.DatabaseAvailabilityChecker;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureHelpers;

public class LocalRoutingTableProcedureValidator
extends BaseRoutingTableProcedureValidator {
    private final DatabaseAvailabilityChecker databaseAvailabilityChecker;

    public LocalRoutingTableProcedureValidator(DatabaseAvailabilityChecker databaseAvailabilityChecker, DatabaseReferenceRepository databaseReferenceRepo) {
        super(databaseReferenceRepo);
        this.databaseAvailabilityChecker = databaseAvailabilityChecker;
    }

    @Override
    public void isValidForServerSideRouting(DatabaseReference.Internal databaseReference) throws ProcedureException {
        this.assertDatabaseIsOperational(databaseReference);
    }

    @Override
    public void isValidForClientSideRouting(DatabaseReference.Internal databaseReference) throws ProcedureException {
        this.assertDatabaseIsOperational(databaseReference);
    }

    private void assertDatabaseIsOperational(DatabaseReference.Internal databaseReference) throws ProcedureException {
        if (!this.databaseAvailabilityChecker.isPresent(databaseReference)) {
            throw RoutingTableProcedureHelpers.databaseNotFoundException(databaseReference.alias().name());
        }
        if (!this.databaseAvailabilityChecker.isAvailable(databaseReference)) {
            throw new ProcedureException((Status)Status.Database.DatabaseUnavailable, "Unable to get a routing table for database '" + databaseReference.alias().name() + "' because this database is unavailable", new Object[0]);
        }
    }
}

