/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.Optional;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class RoutingTableProcedureHelpers {
    RoutingTableProcedureHelpers() {
    }

    static Optional<SocketAddress> findClientProvidedAddress(MapValue routingContext, int defaultBoltPort, Log log) throws ProcedureException {
        AnyValue address = routingContext.get("address");
        if (address == null || address == Values.NO_VALUE) {
            return Optional.empty();
        }
        if (address instanceof TextValue) {
            try {
                String clientProvidedAddress = ((TextValue)address).stringValue();
                if (clientProvidedAddress != null && !clientProvidedAddress.isEmpty() && !clientProvidedAddress.isBlank()) {
                    return Optional.of(SocketAddressParser.socketAddress((String)clientProvidedAddress, (int)defaultBoltPort, SocketAddress::new));
                }
            }
            catch (Exception e) {
                log.warn("Exception attempting to determine address value from routing context", (Throwable)e);
            }
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "An address key is included in the query string provided to the GetRoutingTableProcedure, but its value could not be parsed.", new Object[0]);
    }

    static ProcedureException databaseNotFoundException(String databaseName) {
        return new ProcedureException((Status)Status.Database.DatabaseNotFound, "Unable to get a routing table for database '" + databaseName + "' because this database does not exist", new Object[0]);
    }
}

