/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.expressions.functions.Category;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.temporal.DateFunction;
import org.neo4j.procedure.impl.temporal.DateTimeFunction;
import org.neo4j.procedure.impl.temporal.DurationFunction;
import org.neo4j.procedure.impl.temporal.LocalDateTimeFunction;
import org.neo4j.procedure.impl.temporal.LocalTimeFunction;
import org.neo4j.procedure.impl.temporal.TimeFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class TemporalFunction<T extends AnyValue>
implements CallableUserFunction {
    private static final String DEFAULT_TEMPORAL_ARGUMENT = "DEFAULT_TEMPORAL_ARGUMENT";
    private static final TextValue DEFAULT_TEMPORAL_ARGUMENT_VALUE = Values.utf8Value((String)"DEFAULT_TEMPORAL_ARGUMENT");
    private static final DefaultParameterValue DEFAULT_PARAMETER_VALUE = new DefaultParameterValue((Object)"DEFAULT_TEMPORAL_ARGUMENT", Neo4jTypes.NTAny);
    private static final String TEMPORAL_CATEGORY = Category.TEMPORAL();
    private static final List<FieldSignature> INPUT_SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE));
    private static final String[] ALLOWED = new String[0];
    private final UserFunctionSignature signature;
    private final Supplier<ZoneId> defaultZone;

    public static void registerTemporalFunctions(GlobalProcedures globalProcedures, ProcedureConfig procedureConfig) throws ProcedureException {
        Supplier<ZoneId> defaultZone = procedureConfig::getDefaultTemporalTimeZone;
        TemporalFunction.register(new DateTimeFunction(defaultZone), globalProcedures);
        TemporalFunction.register(new LocalDateTimeFunction(defaultZone), globalProcedures);
        TemporalFunction.register(new DateFunction(defaultZone), globalProcedures);
        TemporalFunction.register(new TimeFunction(defaultZone), globalProcedures);
        TemporalFunction.register(new LocalTimeFunction(defaultZone), globalProcedures);
        DurationFunction.register(globalProcedures);
    }

    protected abstract T now(Clock var1, String var2, Supplier<ZoneId> var3);

    protected abstract T parse(TextValue var1, Supplier<ZoneId> var2);

    protected abstract T build(MapValue var1, Supplier<ZoneId> var2);

    protected abstract T select(AnyValue var1, Supplier<ZoneId> var2);

    protected abstract T truncate(TemporalUnit var1, TemporalValue var2, MapValue var3, Supplier<ZoneId> var4);

    TemporalFunction(Neo4jTypes.AnyType result, Supplier<ZoneId> defaultZone) {
        String basename = TemporalFunction.basename(this.getClass());
        assert (result.getClass().getSimpleName().equals(basename + "Type")) : "result type should match function name";
        Description description = this.getClass().getAnnotation(Description.class);
        this.signature = new UserFunctionSignature(new QualifiedName(new String[0], basename.toLowerCase()), INPUT_SIGNATURE, result, null, ALLOWED, description == null ? null : description.value(), TEMPORAL_CATEGORY, true, true);
        this.defaultZone = defaultZone;
    }

    private static void register(TemporalFunction<?> base, GlobalProcedures globalProcedures) throws ProcedureException {
        globalProcedures.registerBuiltIn(base);
        globalProcedures.registerBuiltIn(new Now(base, "transaction"));
        globalProcedures.registerBuiltIn(new Now(base, "statement"));
        globalProcedures.registerBuiltIn(new Now(base, "realtime"));
        globalProcedures.registerBuiltIn(new Truncate(base));
        base.registerMore(globalProcedures);
    }

    private static String basename(Class<? extends TemporalFunction> function) {
        return function.getSimpleName().replace("Function", "");
    }

    void registerMore(GlobalProcedures globalProcedures) throws ProcedureException {
    }

    public final UserFunctionSignature signature() {
        return this.signature;
    }

    public boolean threadSafe() {
        return true;
    }

    public final AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
        if (input == null || input.length > 0 && (input[0] == Values.NO_VALUE || input[0] == null)) {
            return Values.NO_VALUE;
        }
        if (input.length == 0 || input[0].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
            return this.now(ctx.statementClock(), null, this.defaultZone);
        }
        if (input[0] instanceof TextValue) {
            return this.parse((TextValue)input[0], this.defaultZone);
        }
        if (input[0] instanceof TemporalValue) {
            return this.select(input[0], this.defaultZone);
        }
        if (input[0] instanceof MapValue) {
            MapValue map = (MapValue)input[0];
            String timezone = TemporalFunction.onlyTimezone(map);
            if (timezone != null) {
                return this.now(ctx.statementClock(), timezone, this.defaultZone);
            }
            return this.build(map, this.defaultZone);
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input), new Object[0]);
    }

    private static String onlyTimezone(MapValue map) {
        AnyValue timezone;
        String key;
        if (map.size() == 1 && "timezone".equalsIgnoreCase(key = (String)Iterables.single((Iterable)map.keySet())) && (timezone = map.get(key)) instanceof TextValue) {
            return ((TextValue)timezone).stringValue();
        }
        return null;
    }

    private static class Truncate<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"unit", (Neo4jTypes.AnyType)Neo4jTypes.NTString), FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE), FieldSignature.inputField((String)"fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTMap)));

        Truncate(TemporalFunction<T> function) {
            super(function, "truncate", SIGNATURE, String.format("Truncate the input temporal value to a %s instant using the specified unit.", TemporalFunction.basename(function.getClass())));
        }

        public T apply(Context ctx, AnyValue[] args) throws ProcedureException {
            if (args != null && args.length >= 1 && args.length <= 3) {
                MapValue fields;
                AnyValue unit = args[0];
                AnyValue input = args.length < 2 || args[1].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE) ? this.function.apply(ctx, new AnyValue[]{DEFAULT_TEMPORAL_ARGUMENT_VALUE}) : args[1];
                Object object = fields = args.length < 3 || args[2] == Values.NO_VALUE ? VirtualValues.EMPTY_MAP : args[2];
                if (unit instanceof TextValue && input instanceof TemporalValue && fields instanceof MapValue) {
                    return this.function.truncate(Truncate.unit(((TextValue)unit).stringValue()), (TemporalValue)input, fields, this.function.defaultZone);
                }
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(args), new Object[0]);
        }

        private static TemporalUnit unit(String unit) {
            switch (unit) {
                case "millennium": {
                    return ChronoUnit.MILLENNIA;
                }
                case "century": {
                    return ChronoUnit.CENTURIES;
                }
                case "decade": {
                    return ChronoUnit.DECADES;
                }
                case "year": {
                    return ChronoUnit.YEARS;
                }
                case "weekYear": {
                    return IsoFields.WEEK_BASED_YEARS;
                }
                case "quarter": {
                    return IsoFields.QUARTER_YEARS;
                }
                case "month": {
                    return ChronoUnit.MONTHS;
                }
                case "week": {
                    return ChronoUnit.WEEKS;
                }
                case "day": {
                    return ChronoUnit.DAYS;
                }
                case "hour": {
                    return ChronoUnit.HOURS;
                }
                case "minute": {
                    return ChronoUnit.MINUTES;
                }
                case "second": {
                    return ChronoUnit.SECONDS;
                }
                case "millisecond": {
                    return ChronoUnit.MILLIS;
                }
                case "microsecond": {
                    return ChronoUnit.MICROS;
                }
            }
            throw new IllegalArgumentException("Unsupported unit: " + unit);
        }
    }

    private static class Now<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"timezone", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE));
        private final ThrowingFunction<Context, Clock, ProcedureException> clockSupplier;

        Now(TemporalFunction<T> function, String clock) {
            super(function, clock, SIGNATURE, String.format("Get the current %s instant using the %s clock.", TemporalFunction.basename(function.getClass()), clock));
            switch (clock) {
                case "transaction": {
                    this.clockSupplier = Context::transactionClock;
                    break;
                }
                case "statement": {
                    this.clockSupplier = Context::statementClock;
                    break;
                }
                case "realtime": {
                    this.clockSupplier = Context::systemClock;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized clock: " + clock);
                }
            }
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input == null || input.length > 0 && (input[0] == Values.NO_VALUE || input[0] == null)) {
                return Values.NO_VALUE;
            }
            if (input.length == 0 || input[0].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
                return this.function.now((Clock)this.clockSupplier.apply((Object)ctx), null, this.function.defaultZone);
            }
            if (input.length == 1 && input[0] instanceof TextValue) {
                TextValue timezone = (TextValue)input[0];
                return this.function.now((Clock)this.clockSupplier.apply((Object)ctx), timezone.stringValue(), this.function.defaultZone);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input), new Object[0]);
        }
    }

    private static abstract class SubFunction<T extends AnyValue>
    implements CallableUserFunction {
        private final UserFunctionSignature signature;
        final TemporalFunction<T> function;

        SubFunction(TemporalFunction<T> base, String name, List<FieldSignature> input, String description) {
            this.function = base;
            this.signature = new UserFunctionSignature(new QualifiedName(new String[]{base.signature.name().name()}, name), input, base.signature.outputType(), null, ALLOWED, description, TEMPORAL_CATEGORY, true, true);
        }

        public final UserFunctionSignature signature() {
            return this.signature;
        }

        public abstract AnyValue apply(Context var1, AnyValue[] var2) throws ProcedureException;

        public boolean threadSafe() {
            return true;
        }
    }
}

