/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public class ProcedureTransactionProvider
implements ThrowingFunction<Context, Transaction, ProcedureException> {
    public Transaction apply(Context ctx) throws ProcedureException {
        InternalTransaction ktx = ctx.internalTransaction();
        return new ProcedureTransactionImpl(ktx);
    }

    private static class ProcedureTransactionImpl
    implements InternalTransaction {
        private final InternalTransaction transaction;

        ProcedureTransactionImpl(InternalTransaction transaction) {
            this.transaction = transaction;
        }

        public void commit() {
            throw new UnsupportedOperationException("Commit of ongoing transaction inside of procedure is unsupported.");
        }

        public void rollback() {
            throw new UnsupportedOperationException("Rollback of ongoing transaction inside of procedure is unsupported.");
        }

        public Node createNode() {
            return this.transaction.createNode();
        }

        public Node createNode(Label ... labels) {
            return this.transaction.createNode(labels);
        }

        public Node getNodeById(long id) {
            return this.transaction.getNodeById(id);
        }

        public Result execute(String query) throws QueryExecutionException {
            return this.transaction.execute(query);
        }

        public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
            return this.transaction.execute(query, parameters);
        }

        public Relationship getRelationshipById(long id) {
            return this.transaction.getRelationshipById(id);
        }

        public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
            return this.transaction.bidirectionalTraversalDescription();
        }

        public TraversalDescription traversalDescription() {
            return this.transaction.traversalDescription();
        }

        public Iterable<Label> getAllLabelsInUse() {
            return this.transaction.getAllLabelsInUse();
        }

        public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
            return this.transaction.getAllRelationshipTypesInUse();
        }

        public Iterable<Label> getAllLabels() {
            return this.transaction.getAllLabels();
        }

        public Iterable<RelationshipType> getAllRelationshipTypes() {
            return this.transaction.getAllRelationshipTypes();
        }

        public Iterable<String> getAllPropertyKeys() {
            return this.transaction.getAllPropertyKeys();
        }

        public Node findNode(Label myLabel, String key, Object value) {
            return this.transaction.findNode(myLabel, key, value);
        }

        public ResourceIterator<Node> findNodes(Label myLabel) {
            return this.transaction.findNodes(myLabel);
        }

        public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
            return this.transaction.findNodes(myLabel, key, value);
        }

        public ResourceIterator<Node> findNodes(Label myLabel, String key, String value, StringSearchMode searchMode) {
            return this.transaction.findNodes(myLabel, key, value, searchMode);
        }

        public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
            return this.transaction.findNodes(label, key1, value1, key2, value2, key3, value3);
        }

        public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
            return this.transaction.findNodes(label, key1, value1, key2, value2);
        }

        public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
            return this.transaction.findNodes(label, propertyValues);
        }

        public ResourceIterable<Node> getAllNodes() {
            return this.transaction.getAllNodes();
        }

        public ResourceIterable<Relationship> getAllRelationships() {
            return this.transaction.getAllRelationships();
        }

        public void close() {
            throw new UnsupportedOperationException("Close of ongoing transaction inside of procedure is unsupported.");
        }

        public void setTransaction(KernelTransaction transaction) {
            this.transaction.setTransaction(transaction);
        }

        public Lock acquireWriteLock(Entity entity) {
            return this.transaction.acquireWriteLock(entity);
        }

        public Lock acquireReadLock(Entity entity) {
            return this.transaction.acquireReadLock(entity);
        }

        public Schema schema() {
            return this.transaction.schema();
        }

        public KernelTransaction kernelTransaction() {
            return this.transaction.kernelTransaction();
        }

        public KernelTransaction.Type transactionType() {
            return this.transaction.transactionType();
        }

        public SecurityContext securityContext() {
            return this.transaction.securityContext();
        }

        public ClientConnectionInfo clientInfo() {
            return this.transaction.clientInfo();
        }

        public KernelTransaction.Revertable overrideWith(SecurityContext context) {
            return this.transaction.overrideWith(context);
        }

        public Optional<Status> terminationReason() {
            return this.transaction.terminationReason();
        }

        public void setMetaData(Map<String, Object> txMeta) {
            this.transaction.setMetaData(txMeta);
        }

        public void checkInTransaction() {
            this.transaction.checkInTransaction();
        }

        public boolean isOpen() {
            return this.transaction.isOpen();
        }

        public void terminate(Status reason) {
            this.transaction.terminate(reason);
        }

        public UUID getDatabaseId() {
            return this.transaction.getDatabaseId();
        }

        public String getDatabaseName() {
            return this.transaction.getDatabaseName();
        }

        public <E extends Entity> E validateSameDB(E entity) {
            return (E)this.transaction.validateSameDB(entity);
        }

        public void terminate() {
            this.transaction.terminate();
        }

        public Relationship newRelationshipEntity(long id) {
            return this.transaction.newRelationshipEntity(id);
        }

        public Relationship newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
            return this.transaction.newRelationshipEntity(id, startNodeId, typeId, endNodeId);
        }

        public Node newNodeEntity(long nodeId) {
            return this.transaction.newNodeEntity(nodeId);
        }

        public RelationshipType getRelationshipTypeById(int type) {
            return this.transaction.getRelationshipTypeById(type);
        }
    }
}

