/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.procedure.builtin.routing.ParameterNames;
import org.neo4j.procedure.builtin.routing.Role;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public class RoutingResultFormat {
    private static final String ROLE_KEY = "role";
    private static final String ADDRESSES_KEY = "addresses";

    private RoutingResultFormat() {
    }

    public static AnyValue[] build(RoutingResult result) {
        MapValueBuilder builder;
        AnyValue[] routers = RoutingResultFormat.asValues(result.routeEndpoints());
        AnyValue[] readers = RoutingResultFormat.asValues(result.readEndpoints());
        AnyValue[] writers = RoutingResultFormat.asValues(result.writeEndpoints());
        ArrayList<MapValue> servers = new ArrayList<MapValue>();
        if (writers.length > 0) {
            builder = new MapValueBuilder();
            builder.add(ROLE_KEY, (AnyValue)Values.stringValue((String)Role.WRITE.name()));
            builder.add(ADDRESSES_KEY, (AnyValue)VirtualValues.list((AnyValue[])writers));
            servers.add(builder.build());
        }
        if (readers.length > 0) {
            builder = new MapValueBuilder();
            builder.add(ROLE_KEY, (AnyValue)Values.stringValue((String)Role.READ.name()));
            builder.add(ADDRESSES_KEY, (AnyValue)VirtualValues.list((AnyValue[])readers));
            servers.add(builder.build());
        }
        if (routers.length > 0) {
            builder = new MapValueBuilder();
            builder.add(ROLE_KEY, (AnyValue)Values.stringValue((String)Role.ROUTE.name()));
            builder.add(ADDRESSES_KEY, (AnyValue)VirtualValues.list((AnyValue[])routers));
            servers.add(builder.build());
        }
        LongValue timeToLiveSeconds = Values.longValue((long)TimeUnit.MILLISECONDS.toSeconds(result.ttlMillis()));
        return new AnyValue[]{timeToLiveSeconds, VirtualValues.fromList(servers)};
    }

    public static RoutingResult parse(AnyValue[] record) {
        LongValue timeToLiveSeconds = (LongValue)record[0];
        ListValue endpointData = (ListValue)record[1];
        Map<Role, List<SocketAddress>> endpoints = RoutingResultFormat.parseRows(endpointData);
        return new RoutingResult(endpoints.get((Object)Role.ROUTE), endpoints.get((Object)Role.WRITE), endpoints.get((Object)Role.READ), timeToLiveSeconds.longValue() * 1000L);
    }

    public static RoutingResult parse(MapValue record) {
        return RoutingResultFormat.parse(new AnyValue[]{record.get(ParameterNames.TTL.parameterName()), record.get(ParameterNames.SERVERS.parameterName())});
    }

    public static List<SocketAddress> parseEndpoints(ListValue addresses) {
        ArrayList<SocketAddress> result = new ArrayList<SocketAddress>(addresses.size());
        for (AnyValue address : addresses) {
            result.add(RoutingResultFormat.parseAddress(((TextValue)address).stringValue()));
        }
        return result;
    }

    private static Map<Role, List<SocketAddress>> parseRows(ListValue rows) {
        HashMap<Role, List<SocketAddress>> endpoints = new HashMap<Role, List<SocketAddress>>();
        for (AnyValue single : rows) {
            MapValue row = (MapValue)single;
            Role role = Role.valueOf(((TextValue)row.get(ROLE_KEY)).stringValue());
            List<SocketAddress> addresses = RoutingResultFormat.parseEndpoints((ListValue)row.get(ADDRESSES_KEY));
            endpoints.put(role, addresses);
        }
        Arrays.stream(Role.values()).forEach(r -> endpoints.putIfAbsent((Role)((Object)r), Collections.emptyList()));
        return endpoints;
    }

    private static SocketAddress parseAddress(String address) {
        String[] split = address.split(":");
        return new SocketAddress(split[0], Integer.parseInt(split[1]));
    }

    private static AnyValue[] asValues(List<SocketAddress> addresses) {
        return (AnyValue[])addresses.stream().map(SocketAddress::toString).map(Values::stringValue).toArray(AnyValue[]::new);
    }
}

