/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.string.HexString;

public class StoreIdDecodeUtils {
    private static final String DEFAULT_ALGORITHM = "SHA-256";

    private StoreIdDecodeUtils() {
    }

    public static String decodeId(StoreId storeId) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
        String storeIdString = String.format("%d%d%d", storeId.getCreationTime(), storeId.getRandomId(), storeId.getStoreVersion());
        messageDigest.update(storeIdString.getBytes());
        return HexString.encodeHexString((byte[])messageDigest.digest());
    }
}

