/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.builtin.routing.BaseGetRoutingTableProcedure;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.values.virtual.MapValue;

public class SingleInstanceGetRoutingTableProcedure
extends BaseGetRoutingTableProcedure {
    private static final String DESCRIPTION = "Returns endpoints of this instance.";
    private final ConnectorPortRegister portRegister;

    public SingleInstanceGetRoutingTableProcedure(List<String> namespace, DatabaseManager<?> databaseManager, ConnectorPortRegister portRegister, Config config, LogProvider logProvider) {
        super(namespace, databaseManager, config, logProvider);
        this.portRegister = portRegister;
    }

    @Override
    protected final String description() {
        return DESCRIPTION;
    }

    @Override
    protected RoutingResult invoke(NamedDatabaseId namedDatabaseId, MapValue routingContext) throws ProcedureException {
        this.assertDatabaseIsOperational(namedDatabaseId);
        if (((Boolean)this.config.get(BoltConnector.enabled)).booleanValue()) {
            return this.createRoutingResult(this.findAdvertisedBoltAddress(), this.configuredRoutingTableTtl());
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Cannot get routing table for " + namedDatabaseId.name() + " because Bolt is not enabled. Please update your configuration for '" + BoltConnector.enabled.name() + "'", new Object[0]);
    }

    private void assertDatabaseIsOperational(NamedDatabaseId namedDatabaseId) throws ProcedureException {
        Optional<Database> database = this.getDatabase(namedDatabaseId);
        if (database.isEmpty()) {
            throw SingleInstanceGetRoutingTableProcedure.databaseNotFoundException(namedDatabaseId.name());
        }
        if (!database.get().getDatabaseAvailabilityGuard().isAvailable()) {
            throw new ProcedureException((Status)Status.Database.DatabaseUnavailable, "Unable to get a routing table for database '" + namedDatabaseId.name() + "' because this database is unavailable", new Object[0]);
        }
    }

    protected RoutingResult createRoutingResult(SocketAddress address, long routingTableTtl) {
        List<SocketAddress> addresses = Collections.singletonList(address);
        return new RoutingResult(addresses, addresses, addresses, routingTableTtl);
    }

    private long configuredRoutingTableTtl() {
        return ((Duration)this.config.get(GraphDatabaseSettings.routing_ttl)).toMillis();
    }

    private SocketAddress findAdvertisedBoltAddress() {
        HostnamePort localAddress;
        SocketAddress advertisedAddress = (SocketAddress)this.config.get(BoltConnector.advertised_address);
        if (advertisedAddress.getPort() == 0 && (localAddress = this.portRegister.getLocalAddress("bolt")) != null) {
            advertisedAddress = new SocketAddress(advertisedAddress.getHostname(), localAddress.getPort());
        }
        return advertisedAddress;
    }
}

