/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.builtin.routing.BaseGetRoutingTableProcedure;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.values.virtual.MapValue;

public class SingleInstanceGetRoutingTableProcedure
extends BaseGetRoutingTableProcedure {
    private static final String DESCRIPTION = "Returns endpoints of this instance.";
    private final ConnectorPortRegister portRegister;

    public SingleInstanceGetRoutingTableProcedure(List<String> namespace, DatabaseManager<?> databaseManager, ConnectorPortRegister portRegister, Config config, LogProvider logProvider) {
        super(namespace, databaseManager, config, logProvider);
        this.portRegister = portRegister;
    }

    @Override
    protected final String description() {
        return DESCRIPTION;
    }

    @Override
    protected RoutingResult invoke(NamedDatabaseId namedDatabaseId, MapValue routingContext) {
        if (((Boolean)this.config.get(BoltConnector.enabled)).booleanValue()) {
            return this.createRoutingResult(this.findAdvertisedBoltAddress(), this.configuredRoutingTableTtl());
        }
        return this.createEmptyRoutingResult();
    }

    protected RoutingResult createRoutingResult(SocketAddress address, long routingTableTtl) {
        List<SocketAddress> addresses = Collections.singletonList(address);
        return new RoutingResult(addresses, addresses, addresses, routingTableTtl);
    }

    private RoutingResult createEmptyRoutingResult() {
        return new RoutingResult(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.configuredRoutingTableTtl());
    }

    private long configuredRoutingTableTtl() {
        return ((Duration)this.config.get(GraphDatabaseSettings.routing_ttl)).toMillis();
    }

    private SocketAddress findAdvertisedBoltAddress() {
        HostnamePort localAddress;
        SocketAddress advertisedAddress = (SocketAddress)this.config.get(BoltConnector.advertised_address);
        if (advertisedAddress.getPort() == 0 && (localAddress = this.portRegister.getLocalAddress("bolt")) != null) {
            advertisedAddress = new SocketAddress(advertisedAddress.getHostname(), localAddress.getPort());
        }
        return advertisedAddress;
    }
}

