/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.expressions.functions.Category;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.temporal.DateFunction;
import org.neo4j.procedure.impl.temporal.DateTimeFunction;
import org.neo4j.procedure.impl.temporal.DurationFunction;
import org.neo4j.procedure.impl.temporal.LocalDateTimeFunction;
import org.neo4j.procedure.impl.temporal.LocalTimeFunction;
import org.neo4j.procedure.impl.temporal.TimeFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class TemporalFunction<T extends AnyValue>
implements CallableUserFunction {
    private static final String DEFAULT_TEMPORAL_ARGUMENT = "DEFAULT_TEMPORAL_ARGUMENT";
    private static final TextValue DEFAULT_TEMPORAL_ARGUMENT_VALUE = Values.utf8Value((String)"DEFAULT_TEMPORAL_ARGUMENT");
    static final DefaultParameterValue DEFAULT_PARAMETER_VALUE = new DefaultParameterValue((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE, Neo4jTypes.NTAny);
    static final DefaultParameterValue DEFAULT_PATTERN_PARAMETER_VALUE = new DefaultParameterValue((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE, (Neo4jTypes.AnyType)Neo4jTypes.NTString);
    private static final String TEMPORAL_CATEGORY = Category.TEMPORAL();
    private final UserFunctionSignature signature;
    private final Supplier<ZoneId> defaultZone;

    public static void registerTemporalFunctions(GlobalProcedures globalProcedures, ProcedureConfig procedureConfig) throws ProcedureException {
        Supplier<ZoneId> defaultZone = procedureConfig::getDefaultTemporalTimeZone;
        TemporalFunction.register(DateTimeFunction::new, defaultZone, globalProcedures);
        TemporalFunction.register(LocalDateTimeFunction::new, defaultZone, globalProcedures);
        TemporalFunction.register(DateFunction::new, defaultZone, globalProcedures);
        TemporalFunction.register(TimeFunction::new, defaultZone, globalProcedures);
        TemporalFunction.register(LocalTimeFunction::new, defaultZone, globalProcedures);
        DurationFunction.register(globalProcedures);
    }

    protected abstract T now(Clock var1, String var2, Supplier<ZoneId> var3);

    protected abstract T parse(TextValue var1, Supplier<ZoneId> var2);

    protected abstract T parsePattern(TextValue var1, TextValue var2, Supplier<ZoneId> var3);

    protected abstract T build(MapValue var1, Supplier<ZoneId> var2);

    protected abstract T select(AnyValue var1, Supplier<ZoneId> var2);

    protected abstract T truncate(TemporalUnit var1, TemporalValue var2, MapValue var3, Supplier<ZoneId> var4);

    protected abstract String getTemporalCypherTypeName();

    protected abstract List<FieldSignature> getTemporalTruncateSignature();

    TemporalFunction(Neo4jTypes.AnyType result, List<FieldSignature> inputSignature, Set<QueryLanguage> supportedQueryLanguages, Supplier<ZoneId> defaultZone) {
        String basename = TemporalFunction.basename(this.getClass());
        assert (result.getClass().getSimpleName().equals(basename + "Type")) : "result type should match function name";
        Description description = this.getClass().getAnnotation(Description.class);
        this.signature = new UserFunctionSignature(new QualifiedName(basename.toLowerCase(Locale.ROOT)), inputSignature, result, false, null, description == null ? null : description.value(), TEMPORAL_CATEGORY, true, true, false, true, supportedQueryLanguages);
        this.defaultZone = defaultZone;
    }

    private static void register(BiFunction<Set<QueryLanguage>, Supplier<ZoneId>, TemporalFunction<?>> func, Supplier<ZoneId> defaultZone, GlobalProcedures globalProcedures) throws ProcedureException {
        TemporalFunction<?> base = func.apply(Set.of(QueryLanguage.CYPHER_25), defaultZone);
        globalProcedures.register(base);
        globalProcedures.register((CallableUserFunction)func.apply(Set.of(QueryLanguage.CYPHER_5), defaultZone));
        globalProcedures.register(new Now(base, "transaction"));
        globalProcedures.register(new Now(base, "statement"));
        globalProcedures.register(new Now(base, "realtime"));
        globalProcedures.register(new Truncate(base));
        base.registerMore(globalProcedures);
    }

    private static String basename(Class<? extends TemporalFunction> function) {
        return function.getSimpleName().replace("Function", "");
    }

    void registerMore(GlobalProcedures globalProcedures) throws ProcedureException {
    }

    public final UserFunctionSignature signature() {
        return this.signature;
    }

    public final AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
        if (input == null || input.length > 0 && (input[0] == Values.NO_VALUE || input[0] == null) || input.length > 1 && (input[1] == Values.NO_VALUE || input[1] == null)) {
            return Values.NO_VALUE;
        }
        if (input.length == 0 || input[0].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
            return this.now(ctx.statementClock(), null, this.defaultZone);
        }
        if (input[0] instanceof TextValue) {
            if (input.length == 1 || input[1].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
                return this.parse((TextValue)input[0], this.defaultZone);
            }
            if (input[1] instanceof TextValue) {
                return this.parsePattern((TextValue)input[0], (TextValue)input[1], this.defaultZone);
            }
        } else {
            TextValue pattern;
            AnyValue anyValue;
            if (input.length == 2 && (anyValue = input[1]) instanceof TextValue && !(pattern = (TextValue)anyValue).equals(DEFAULT_PATTERN_PARAMETER_VALUE.value())) {
                throw ProcedureException.invalidFunctionArgument((String)this.signature.toString(), (String)"A pattern can only be used in conjunction with a `STRING` input");
            }
            if (input[0] instanceof TemporalValue) {
                return this.select(input[0], this.defaultZone);
            }
            anyValue = input[0];
            if (anyValue instanceof MapValue) {
                MapValue map = (MapValue)anyValue;
                String timezone = TemporalFunction.onlyTimezone(map);
                if (timezone != null) {
                    return this.now(ctx.statementClock(), timezone, this.defaultZone);
                }
                return this.build(map, this.defaultZone);
            }
        }
        throw ProcedureException.invalidCallSignature((String)String.valueOf(this.signature.name()), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
    }

    private static String onlyTimezone(MapValue map) {
        AnyValue timezone;
        String key;
        if (map.size() == 1 && "timezone".equalsIgnoreCase(key = (String)Iterables.single((Iterable)map.keySet())) && (timezone = map.get(key)) instanceof TextValue) {
            return ((TextValue)timezone).stringValue();
        }
        return null;
    }

    private static class Now<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"timezone", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"A string value representing a time zone."));
        private final ThrowingFunction<Context, Clock, ProcedureException> clockSupplier;

        Now(TemporalFunction<T> function, String clock) {
            super(function, clock, SIGNATURE, String.format("Returns the current `%s` instant using the %s clock.", function.getTemporalCypherTypeName(), clock));
            switch (clock) {
                case "transaction": {
                    this.clockSupplier = Context::transactionClock;
                    break;
                }
                case "statement": {
                    this.clockSupplier = Context::statementClock;
                    break;
                }
                case "realtime": {
                    this.clockSupplier = Context::systemClock;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized clock: " + clock);
                }
            }
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            AnyValue anyValue;
            if (input == null || input.length > 0 && (input[0] == Values.NO_VALUE || input[0] == null)) {
                return Values.NO_VALUE;
            }
            if (input.length == 0 || input[0].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
                return this.function.now((Clock)this.clockSupplier.apply((Object)ctx), null, this.function.defaultZone);
            }
            if (input.length == 1 && (anyValue = input[0]) instanceof TextValue) {
                TextValue timezone = (TextValue)anyValue;
                return this.function.now((Clock)this.clockSupplier.apply((Object)ctx), timezone.stringValue(), this.function.defaultZone);
            }
            throw ProcedureException.invalidCallSignature((String)String.valueOf(this.signature().name()), (String)this.signature().toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
        }
    }

    private static class Truncate<T extends AnyValue>
    extends SubFunction<T> {
        Truncate(TemporalFunction<T> function) {
            super(function, "truncate", function.getTemporalTruncateSignature(), String.format("Truncates the given temporal value to a `%s` instant using the specified unit.", function.getTemporalCypherTypeName()));
        }

        public T apply(Context ctx, AnyValue[] args) throws ProcedureException {
            if (args != null && args.length >= 1 && args.length <= 3) {
                MapValue fields;
                AnyValue unit = args[0];
                AnyValue input = args.length < 2 || args[1].equals((Object)DEFAULT_TEMPORAL_ARGUMENT_VALUE) ? this.function.apply(ctx, new AnyValue[]{DEFAULT_TEMPORAL_ARGUMENT_VALUE}) : args[1];
                Object object = fields = args.length < 3 || args[2] == Values.NO_VALUE ? VirtualValues.EMPTY_MAP : args[2];
                if (unit instanceof TextValue && input instanceof TemporalValue && fields instanceof MapValue) {
                    return this.function.truncate(Truncate.unit(((TextValue)unit).stringValue()), (TemporalValue)input, fields, this.function.defaultZone);
                }
            }
            throw ProcedureException.invalidCallSignature((String)String.valueOf(this.signature().name()), (String)this.signature().toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(args)));
        }

        private static TemporalUnit unit(String unit) {
            switch (unit) {
                case "millennium": {
                    return ChronoUnit.MILLENNIA;
                }
                case "century": {
                    return ChronoUnit.CENTURIES;
                }
                case "decade": {
                    return ChronoUnit.DECADES;
                }
                case "year": {
                    return ChronoUnit.YEARS;
                }
                case "weekYear": {
                    return IsoFields.WEEK_BASED_YEARS;
                }
                case "quarter": {
                    return IsoFields.QUARTER_YEARS;
                }
                case "month": {
                    return ChronoUnit.MONTHS;
                }
                case "week": {
                    return ChronoUnit.WEEKS;
                }
                case "day": {
                    return ChronoUnit.DAYS;
                }
                case "hour": {
                    return ChronoUnit.HOURS;
                }
                case "minute": {
                    return ChronoUnit.MINUTES;
                }
                case "second": {
                    return ChronoUnit.SECONDS;
                }
                case "millisecond": {
                    return ChronoUnit.MILLIS;
                }
                case "microsecond": {
                    return ChronoUnit.MICROS;
                }
            }
            throw new IllegalArgumentException("Unsupported unit: " + unit);
        }
    }

    private static abstract class SubFunction<T extends AnyValue>
    implements CallableUserFunction {
        private final UserFunctionSignature signature;
        final TemporalFunction<T> function;

        SubFunction(TemporalFunction<T> base, String name, List<FieldSignature> input, String description) {
            this.function = base;
            this.signature = new UserFunctionSignature(new QualifiedName(base.signature.name().name(), name), input, base.signature.outputType(), false, null, description, TEMPORAL_CATEGORY, true, true, false, true, QueryLanguage.ALL);
        }

        public final UserFunctionSignature signature() {
            return this.signature;
        }

        public abstract AnyValue apply(Context var1, AnyValue[] var2) throws ProcedureException;
    }
}

