/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Creates a `LOCAL TIME` instant.")
class LocalTimeFunction
extends TemporalFunction<LocalTimeValue> {
    private static final List<FieldSignature> INPUT_SIGNATURE_CYPHER_5 = Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"Either a string representation of a temporal value, a map containing the single key 'timezone', or a map containing temporal values ('hour, 'minute', 'second', 'millisecond', 'microsecond', 'nanosecond' as components."));
    private static final List<FieldSignature> INPUT_SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"Either a string representation of a temporal value, a map containing the single key 'timezone', or a map containing temporal values ('hour, 'minute', 'second', 'millisecond', 'microsecond', 'nanosecond' as components."), FieldSignature.inputField((String)"pattern", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DEFAULT_PATTERN_PARAMETER_VALUE, (boolean)false, (String)"A pattern used to parse a local time value. If the pattern is not provided the value will be parsed according to default patterns."));

    LocalTimeFunction(Set<QueryLanguage> supportedQueryLanguages, Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTLocalTime, supportedQueryLanguages.contains(QueryLanguage.CYPHER_5) ? INPUT_SIGNATURE_CYPHER_5 : INPUT_SIGNATURE, supportedQueryLanguages, defaultZone);
    }

    @Override
    protected LocalTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? LocalTimeValue.now((Clock)clock, defaultZone) : LocalTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected LocalTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.parse((TextValue)value);
    }

    @Override
    protected LocalTimeValue parsePattern(TextValue value, TextValue pattern, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.parsePattern((TextValue)value, (TextValue)pattern);
    }

    @Override
    protected LocalTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected LocalTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected List<FieldSignature> getTemporalTruncateSignature() {
        return Arrays.asList(FieldSignature.inputField((String)"unit", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (String)"A string representing one of the following: 'day', 'week', 'month', 'weekYear', 'quarter', 'year', 'decade', 'century', 'millennium'."), FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"The date to be truncated using either `ZONED DATETIME`, `LOCAL DATETIME`, `LOCAL TIME`, or `DATE`."), FieldSignature.inputField((String)"fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTMap), (boolean)false, (String)"A list of time components smaller than those specified in `unit` to preserve during truncation."));
    }

    @Override
    protected LocalTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    protected String getTemporalCypherTypeName() {
        return "LOCAL TIME";
    }
}

