/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.lang.management.ManagementFactory;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.builtin.JmxQueryProcedure;
import org.neo4j.procedure.builtin.ListComponentsProcedure;

public class SpecialBuiltInProcedures {
    private final List<CallableProcedure> builtins;

    private SpecialBuiltInProcedures(List<CallableProcedure> builtins) {
        this.builtins = builtins;
    }

    public void install(GlobalProcedures globalProcedures) throws ProcedureException {
        for (CallableProcedure builtin : this.builtins) {
            globalProcedures.register(builtin);
        }
    }

    public static SpecialBuiltInProcedures from(String neo4jVersion, String neo4jEdition, Config config) {
        String customVersionConfig = (String)config.get(GraphDatabaseInternalSettings.custom_kernel_version);
        Boolean cypherExperimentalVersionsEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.enable_experimental_cypher_versions);
        return new SpecialBuiltInProcedures(List.of(new ListComponentsProcedure(new QualifiedName("dbms", "components"), neo4jVersion, neo4jEdition, customVersionConfig, cypherExperimentalVersionsEnabled), new JmxQueryProcedure(new QualifiedName("dbms", "queryJmx"), ManagementFactory.getPlatformMBeanServer())));
    }
}

