/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;

public class ProcedureConfig {
    private final List<Pattern> accessPatterns;
    private final List<Pattern> whiteList;
    private final ZoneId defaultTemporalTimeZone;
    private final List<String> reservedProcedureNamespaces;
    private final boolean procedureReloadEnabled;
    private final GraphDatabaseInternalSettings.ProcedureClassPreloading preload;
    public static final ProcedureConfig DEFAULT = new ProcedureConfig();

    private ProcedureConfig() {
        this.accessPatterns = Collections.emptyList();
        this.whiteList = Collections.singletonList(ProcedureConfig.compilePattern("*"));
        this.defaultTemporalTimeZone = ZoneOffset.UTC;
        this.reservedProcedureNamespaces = (List)GraphDatabaseInternalSettings.reserved_procedure_namespaces.defaultValue();
        this.procedureReloadEnabled = false;
        this.preload = (GraphDatabaseInternalSettings.ProcedureClassPreloading)GraphDatabaseInternalSettings.preload.defaultValue();
    }

    public ProcedureConfig(Config config) {
        this(config, false);
    }

    public ProcedureConfig(Config config, boolean procedureReloadEnabled) {
        this.accessPatterns = this.parseMatchers((List)config.get(GraphDatabaseSettings.procedure_unrestricted), ProcedureConfig::compilePattern);
        this.whiteList = this.parseMatchers((List)config.get(GraphDatabaseSettings.procedure_allowlist), ProcedureConfig::compilePattern);
        this.defaultTemporalTimeZone = (ZoneId)config.get(GraphDatabaseSettings.db_temporal_timezone);
        this.reservedProcedureNamespaces = (List)config.get(GraphDatabaseInternalSettings.reserved_procedure_namespaces);
        this.procedureReloadEnabled = procedureReloadEnabled;
        this.preload = (GraphDatabaseInternalSettings.ProcedureClassPreloading)config.get(GraphDatabaseInternalSettings.preload);
    }

    private <T> List<T> parseMatchers(List<String> fullAccessProcedures, Function<String, T> matchFunc) {
        if (fullAccessProcedures == null || fullAccessProcedures.isEmpty()) {
            return Collections.emptyList();
        }
        return fullAccessProcedures.stream().map(matchFunc).collect(Collectors.toList());
    }

    public boolean fullAccessFor(String procedureName) {
        return this.accessPatterns.stream().anyMatch(pattern -> pattern.matcher(procedureName).matches());
    }

    public boolean isWhitelisted(String procedureName) {
        return this.whiteList.stream().anyMatch(pattern -> pattern.matcher(procedureName).matches());
    }

    private static Pattern compilePattern(String procedure) {
        procedure = procedure.trim().replaceAll("([\\[\\]\\\\?()^${}+|.])", "\\\\$1");
        return Pattern.compile(procedure.replaceAll("\\*", ".*"));
    }

    public ZoneId getDefaultTemporalTimeZone() {
        return this.defaultTemporalTimeZone;
    }

    public List<String> reservedProcedureNamespaces() {
        return this.reservedProcedureNamespaces;
    }

    public boolean procedureReloadEnabled() {
        return this.procedureReloadEnabled;
    }

    public GraphDatabaseInternalSettings.ProcedureClassPreloading preload() {
        return this.preload;
    }
}

