/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.api.vector.VectorCandidate;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class VectorIndexProcedures {
    private static final long INDEX_ONLINE_QUERY_TIMEOUT_SECONDS = FeatureToggles.getInteger(VectorIndexProcedures.class, (String)"INDEX_ONLINE_QUERY_TIMEOUT_SECONDS", (int)30);
    @Context
    public GraphDatabaseAPI db;
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;
    @Context
    public KernelVersion kernelVersion;
    @Context
    public ProcedureCallContext callContext;

    @Deprecated(since="5.26.0", forRemoval=true)
    @Description(value="Create a named node vector index for the specified label and property with the given vector dimensionality using either the EUCLIDEAN or COSINE similarity function.\nBoth similarity functions are case-insensitive.\nUse the `db.index.vector.queryNodes` procedure to query the named index.\n")
    @Procedure(name="db.index.vector.createNodeIndex", mode=Mode.SCHEMA, deprecatedBy="CREATE VECTOR INDEX")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    public void createIndex(@Name(value="indexName") String name, @Name(value="label") String label, @Name(value="propertyKey") String propertyKey, @Name(value="vectorDimension") Long vectorDimension, @Name(value="vectorSimilarityFunction") String vectorSimilarityFunction) {
        Objects.requireNonNull(name, "'indexName' must not be null");
        Objects.requireNonNull(label, "'label' must not be null");
        Objects.requireNonNull(propertyKey, "'propertyKey' must not be null");
        Objects.requireNonNull(vectorDimension, "'vectorDimension' must not be null");
        VectorIndexVersion version = VectorIndexVersion.latestSupportedVersion((KernelVersion)this.kernelVersion);
        Preconditions.checkState((version != VectorIndexVersion.UNKNOWN ? 1 : 0) != 0, (String)"Vector index version `%s` is not a valid version.");
        Preconditions.checkArgument((1L <= vectorDimension && vectorDimension <= (long)version.maxDimensions() ? 1 : 0) != 0, (String)"'vectorDimension' must be between %d and %d inclusively".formatted(1, version.maxDimensions()));
        version.similarityFunction(Objects.requireNonNull(vectorSimilarityFunction, "'vectorSimilarityFunction' must not be null"));
        this.tx.schema().indexFor(Label.label((String)label)).on(propertyKey).withIndexType(IndexType.VECTOR.toPublicApi()).withIndexConfiguration(Map.of(IndexSetting.vector_Dimensions(), vectorDimension, IndexSetting.vector_Similarity_Function(), vectorSimilarityFunction)).withName(name).create();
    }

    @Description(value="Query the given node vector index.\nReturns requested number of nearest neighbors to the provided query vector,\nand their similarity score to that query vector, based on the configured similarity function for the index.\nThe similarity score is a value between [0, 1]; where 0 indicates least similar, 1 most similar.\n")
    @Procedure(name="db.index.vector.queryNodes", mode=Mode.READ)
    public Stream<NodeNeighbor> queryNodeVectorIndex(@Name(value="indexName", description="The name of the vector index.") String name, @Name(value="numberOfNearestNeighbours", description="The size of the vector neighbourhood.") Long numberOfNearestNeighbours, @Name(value="query", description="The object to find approximate matches for.") AnyValue candidateQuery) throws KernelException {
        VectorCandidate query = VectorIndexProcedures.validateQueryArguments(name, numberOfNearestNeighbours, candidateQuery);
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return new NodeIndexQuery(this.tx, this.ktx, name).query(Math.toIntExact(numberOfNearestNeighbours), query);
    }

    @Description(value="Query the given relationship vector index.\nReturns requested number of nearest neighbors to the provided query vector,\nand their similarity score to that query vector, based on the configured similarity function for the index.\nThe similarity score is a value between [0, 1]; where 0 indicates least similar, 1 most similar.\n")
    @Procedure(name="db.index.vector.queryRelationships", mode=Mode.READ)
    public Stream<RelationshipNeighbor> queryRelationshipVectorIndex(@Name(value="indexName", description="The name of the vector index.") String name, @Name(value="numberOfNearestNeighbours", description="The size of the vector neighbourhood.") Long numberOfNearestNeighbours, @Name(value="query", description="The object to find approximate matches for.") AnyValue candidateQuery) throws KernelException {
        VectorCandidate query = VectorIndexProcedures.validateQueryArguments(name, numberOfNearestNeighbours, candidateQuery);
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return new RelationshipIndexQuery(this.tx, this.ktx, name).query(Math.toIntExact(numberOfNearestNeighbours), query);
    }

    private static VectorCandidate validateQueryArguments(String name, Long numberOfNearestNeighbours, AnyValue candidateQuery) {
        Objects.requireNonNull(name, "'indexName' must not be null");
        Objects.requireNonNull(numberOfNearestNeighbours, "'numberOfNearestNeighbours' must not be null");
        Preconditions.checkArgument((numberOfNearestNeighbours > 0L ? 1 : 0) != 0, (String)"'numberOfNearestNeighbours' must be positive");
        Objects.requireNonNull(candidateQuery, "'query' must not be null");
        if (candidateQuery == Values.NO_VALUE) {
            throw new IllegalArgumentException("'query' must not be NO_VALUE, which is treated as null", new NullPointerException("'query' must not be null"));
        }
        VectorCandidate query = VectorCandidate.maybeFrom((AnyValue)candidateQuery);
        if (query == null) {
            throw new IllegalArgumentException("'query' must be a non-null numerical array");
        }
        return query;
    }

    @Description(value="Set a vector property on a given node in a more space efficient representation than Cypher's SET.")
    @Procedure(name="db.create.setNodeVectorProperty", mode=Mode.WRITE)
    public void setNodeVectorProperty(@Name(value="node", description="The node on which the new property will be stored.") Node node, @Name(value="key", description="The name of the new property.") String propKey, @Name(value="vector", description="The object containing the embedding.") AnyValue candidateVector) {
        this.setVectorProperty((Entity)Objects.requireNonNull(node, "'node' must not be null"), propKey, candidateVector);
    }

    @Description(value="Set a vector property on a given node in a more space efficient representation than Cypher's SET.")
    @Procedure(name="db.create.setVectorProperty", mode=Mode.WRITE, deprecatedBy="db.create.setNodeVectorProperty")
    @Deprecated(since="5.13.0", forRemoval=true)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    public Stream<NodeRecord> deprecatedSetVectorProperty(@Name(value="node", description="The node on which the new property will be stored.") Node node, @Name(value="key", description="The name of the new property.") String propKey, @Name(value="vector", description="The object containing the embedding.") AnyValue candidateVector) {
        this.setNodeVectorProperty(Objects.requireNonNull(node, "'node' must not be null"), propKey, candidateVector);
        return Stream.of(new NodeRecord(node));
    }

    @Description(value="Set a vector property on a given relationship in a more space efficient representation than Cypher's SET.")
    @Procedure(name="db.create.setRelationshipVectorProperty", mode=Mode.WRITE)
    public void setRelationshipVectorProperty(@Name(value="relationship", description="The relationship on which the new property will be stored.") Relationship relationship, @Name(value="key", description="The name of the new property.") String propKey, @Name(value="vector", description="The object containing the embedding.") AnyValue candidateQuery) {
        this.setVectorProperty((Entity)Objects.requireNonNull(relationship, "'relationship' must not be null"), propKey, candidateQuery);
    }

    public void setVectorProperty(Entity entity, String propKey, AnyValue candidateVector) {
        Objects.requireNonNull(propKey, "'key' must not be null");
        Objects.requireNonNull(candidateVector, "'vector' must not be null");
        if (candidateVector == Values.NO_VALUE) {
            throw new IllegalArgumentException("'vector' must not be NO_VALUE, which is treated as null", new NullPointerException("'vector' must not be null"));
        }
        VectorCandidate vector = VectorCandidate.maybeFrom((AnyValue)candidateVector);
        if (vector == null) {
            throw new IllegalArgumentException("'vector' must be a non-null numerical array");
        }
        entity.setProperty(propKey, (Object)VectorSimilarityFunctions.EUCLIDEAN.toValidVector(vector));
    }

    private static float[] validateAndConvertQuery(IndexDescriptor index, VectorCandidate query) {
        VectorIndexVersion version = VectorIndexVersion.fromDescriptor((IndexProviderDescriptor)index.getIndexProvider());
        VectorIndexConfig vectorIndexConfig = version.indexSettingValidator().trustIsValidToVectorIndexConfig((SettingsAccessor)new SettingsAccessor.IndexConfigAccessor(index.getIndexConfig()));
        OptionalInt dimensions = vectorIndexConfig.dimensions();
        if (dimensions.isPresent() && query.dimensions() != dimensions.getAsInt()) {
            throw new IllegalArgumentException("Index query vector has %d dimensions, but indexed vectors have %d.".formatted(query.dimensions(), dimensions.getAsInt()));
        }
        VectorSimilarityFunction similarityFunction = vectorIndexConfig.similarityFunction();
        return similarityFunction.toValidVector(query);
    }

    private IndexDescriptor getValidIndex(String name) {
        IndexDescriptor index = this.ktx.schemaRead().indexGetForName(name);
        if (index == IndexDescriptor.NO_INDEX || index.getIndexType() != IndexType.VECTOR) {
            throw new IllegalArgumentException("There is no such vector schema index: " + name);
        }
        return index;
    }

    private static class NodeIndexQuery
    extends IndexQuery<NodeValueIndexCursor, NodeNeighbor> {
        private NodeIndexQuery(Transaction tx, KernelTransaction ktx, String name) {
            super(EntityType.NODE, tx, ktx, name);
        }

        @Override
        NodeValueIndexCursor cursor(CursorFactory cursorFactory, CursorContext cursorContext, MemoryTracker memoryTracker) {
            return cursorFactory.allocateNodeValueIndexCursor(cursorContext, memoryTracker);
        }

        @Override
        void seek(Read read, QueryContext queryContext, IndexReadSession session, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery.NearestNeighborsPredicate query) throws KernelException {
            read.nodeIndexSeek(queryContext, session, cursor, constraints, new PropertyIndexQuery[]{query});
        }

        @Override
        Stream<NodeNeighbor> stream(NodeValueIndexCursor cursor, int k) {
            return new NodeNeighborSpliterator(this.tx, cursor, k).stream();
        }
    }

    private static class RelationshipIndexQuery
    extends IndexQuery<RelationshipValueIndexCursor, RelationshipNeighbor> {
        private RelationshipIndexQuery(Transaction tx, KernelTransaction ktx, String name) {
            super(EntityType.RELATIONSHIP, tx, ktx, name);
        }

        @Override
        RelationshipValueIndexCursor cursor(CursorFactory cursorFactory, CursorContext cursorContext, MemoryTracker memoryTracker) {
            return cursorFactory.allocateRelationshipValueIndexCursor(cursorContext, memoryTracker);
        }

        @Override
        void seek(Read read, QueryContext queryContext, IndexReadSession session, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery.NearestNeighborsPredicate query) throws KernelException {
            read.relationshipIndexSeek(queryContext, session, cursor, constraints, new PropertyIndexQuery[]{query});
        }

        @Override
        Stream<RelationshipNeighbor> stream(RelationshipValueIndexCursor cursor, int k) {
            return new RelationshipNeighborSpliterator(this.tx, cursor, k).stream();
        }
    }

    public record NodeRecord(@Description(value="The node on which the vector property was set.") Node node) {
    }

    private static interface NeighborSpliterator<NEIGHBOR extends Neighbor<?, NEIGHBOR>>
    extends Spliterator<NEIGHBOR> {
        public int k();

        public Cursor cursor();

        public NEIGHBOR neighbor();

        @Override
        default public boolean tryAdvance(Consumer<? super NEIGHBOR> action) {
            Cursor cursor = this.cursor();
            while (cursor.next()) {
                NEIGHBOR neighbor = this.neighbor();
                if (neighbor == null) continue;
                action.accept(neighbor);
                return true;
            }
            cursor.close();
            return false;
        }

        @Override
        default public long estimateSize() {
            return this.k();
        }

        @Override
        default public Spliterator<NEIGHBOR> trySplit() {
            return null;
        }

        @Override
        default public int characteristics() {
            return 1301;
        }

        @Override
        default public Comparator<? super NEIGHBOR> getComparator() {
            return null;
        }

        default public Stream<NEIGHBOR> stream() {
            Stream stream = StreamSupport.stream(this, false);
            return (Stream)stream.onClose(() -> ((Cursor)this.cursor()).close());
        }
    }

    private static final class RelationshipNeighborSpliterator
    extends Record
    implements NeighborSpliterator<RelationshipNeighbor> {
        private final Transaction tx;
        private final RelationshipValueIndexCursor cursor;
        private final int k;

        private RelationshipNeighborSpliterator(Transaction tx, RelationshipValueIndexCursor cursor, int k) {
            this.tx = tx;
            this.cursor = cursor;
            this.k = k;
        }

        @Override
        public RelationshipNeighbor neighbor() {
            return RelationshipNeighbor.forExistingEntityOrNull(this.tx, this.cursor.relationshipReference(), Math.clamp((double)this.cursor.score(), 0.0, 1.0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RelationshipNeighborSpliterator.class, "tx;cursor;k", "tx", "cursor", "k"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RelationshipNeighborSpliterator.class, "tx;cursor;k", "tx", "cursor", "k"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RelationshipNeighborSpliterator.class, "tx;cursor;k", "tx", "cursor", "k"}, this, o);
        }

        public Transaction tx() {
            return this.tx;
        }

        public RelationshipValueIndexCursor cursor() {
            return this.cursor;
        }

        @Override
        public int k() {
            return this.k;
        }
    }

    private static final class NodeNeighborSpliterator
    extends Record
    implements NeighborSpliterator<NodeNeighbor> {
        private final Transaction tx;
        private final NodeValueIndexCursor cursor;
        private final int k;

        private NodeNeighborSpliterator(Transaction tx, NodeValueIndexCursor cursor, int k) {
            this.tx = tx;
            this.cursor = cursor;
            this.k = k;
        }

        @Override
        public NodeNeighbor neighbor() {
            return NodeNeighbor.forExistingEntityOrNull(this.tx, this.cursor.nodeReference(), Math.clamp((double)this.cursor.score(), 0.0, 1.0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NodeNeighborSpliterator.class, "tx;cursor;k", "tx", "cursor", "k"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NodeNeighborSpliterator.class, "tx;cursor;k", "tx", "cursor", "k"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NodeNeighborSpliterator.class, "tx;cursor;k", "tx", "cursor", "k"}, this, o);
        }

        public Transaction tx() {
            return this.tx;
        }

        public NodeValueIndexCursor cursor() {
            return this.cursor;
        }

        @Override
        public int k() {
            return this.k;
        }
    }

    public static interface Neighbor<ENTITY extends Entity, NEIGHBOR extends Neighbor<ENTITY, NEIGHBOR>>
    extends Comparable<NEIGHBOR> {
        public ENTITY entity();

        public double score();

        @Override
        default public int compareTo(NEIGHBOR o) {
            return -Double.compare(this.score(), o.score());
        }
    }

    public record RelationshipNeighbor(@Description(value="A relationship which contains a vector property similar to the query object.") Relationship relationship, @Description(value="The score measuring how similar the relationship property is to the query object.") double score) implements Neighbor<Relationship, RelationshipNeighbor>
    {
        @Override
        public Relationship entity() {
            return this.relationship;
        }

        public static RelationshipNeighbor forExistingEntityOrNull(Transaction tx, long relId, double score) {
            try {
                return new RelationshipNeighbor(tx.getRelationshipById(relId), score);
            }
            catch (NotFoundException ignore) {
                return null;
            }
        }
    }

    public record NodeNeighbor(@Description(value="A node which contains a vector property similar to the query object.") Node node, @Description(value="The score measuring how similar the node property is to the query object.") double score) implements Neighbor<Node, NodeNeighbor>
    {
        @Override
        public Node entity() {
            return this.node;
        }

        public static NodeNeighbor forExistingEntityOrNull(Transaction tx, long nodeId, double score) {
            try {
                return new NodeNeighbor(tx.getNodeById(nodeId), score);
            }
            catch (NotFoundException ignore) {
                return null;
            }
        }
    }

    private static abstract class IndexQuery<CURSOR extends ValueIndexCursor, NEIGHBOR extends Neighbor<?, NEIGHBOR>> {
        protected final Transaction tx;
        private final KernelTransaction ktx;
        private final IndexDescriptor index;

        private IndexQuery(EntityType entityType, Transaction tx, KernelTransaction ktx, String name) {
            this.tx = tx;
            this.ktx = ktx;
            IndexDescriptor index = ktx.schemaRead().indexGetForName(name);
            if (index == IndexDescriptor.NO_INDEX || index.getIndexType() != IndexType.VECTOR) {
                throw new IllegalArgumentException("There is no such vector schema index: " + name);
            }
            EntityType entityTypeFromIndex = index.schema().entityType();
            if (entityTypeFromIndex != entityType) {
                throw new IllegalArgumentException("The '%s' index (%s) is an index on %s, so it cannot be queried for nodes.".formatted(index.getName(), index, entityTypeFromIndex));
            }
            this.index = index;
            this.awaitIndexOnline();
        }

        abstract CURSOR cursor(CursorFactory var1, CursorContext var2, MemoryTracker var3);

        abstract void seek(Read var1, QueryContext var2, IndexReadSession var3, CURSOR var4, IndexQueryConstraints var5, PropertyIndexQuery.NearestNeighborsPredicate var6) throws KernelException;

        abstract Stream<NEIGHBOR> stream(CURSOR var1, int var2);

        Stream<NEIGHBOR> query(int k, VectorCandidate query) throws KernelException {
            float[] validatedQuery = VectorIndexProcedures.validateAndConvertQuery(this.index, query);
            CURSOR cursor = this.cursor(this.ktx.cursors(), this.ktx.cursorContext(), this.ktx.memoryTracker());
            this.seek(this.ktx.dataRead(), this.ktx.queryContext(), this.ktx.dataRead().indexReadSession(this.index), cursor, IndexQueryConstraints.unconstrained(), PropertyIndexQuery.nearestNeighbors((int)k, (float[])validatedQuery));
            return this.stream(cursor, k);
        }

        private void awaitIndexOnline() {
            TxStateHolder txStateHolder = (TxStateHolder)this.ktx;
            if (!(txStateHolder.hasTxStateWithChanges() && txStateHolder.txState().indexDiffSetsBySchema(this.index.schema()).isAdded((Object)this.index) || this.ktx.isSPDTransaction())) {
                this.tx.schema().awaitIndexOnline(this.index.getName(), INDEX_ONLINE_QUERY_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            }
        }
    }
}

