/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveCommons;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.base.Empty;
import org.neo4j.graphdb.Resource;

public class PrimitiveLongCollections {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final PrimitiveLongIterator EMPTY = new PrimitiveLongBaseIterator(){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    private PrimitiveLongCollections() {
    }

    public static PrimitiveLongIterator iterator(final long ... items) {
        return new PrimitiveLongBaseIterator(){
            private int index = -1;

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length && this.next(items[this.index]);
            }
        };
    }

    public static PrimitiveLongIterator reversed(final long ... items) {
        return new PrimitiveLongBaseIterator(){
            private int index;
            {
                this.index = items.length;
            }

            @Override
            protected boolean fetchNext() {
                return --this.index >= 0 && this.next(items[this.index]);
            }
        };
    }

    public static PrimitiveLongIterator reversed(PrimitiveLongIterator source) {
        long[] items = PrimitiveLongCollections.asArray(source);
        return PrimitiveLongCollections.reversed(items);
    }

    public static PrimitiveLongIterator concat(PrimitiveLongIterator ... primitiveLongIterators) {
        return PrimitiveLongCollections.concat(Arrays.asList(primitiveLongIterators));
    }

    public static PrimitiveLongIterator concat(Iterable<PrimitiveLongIterator> primitiveLongIterators) {
        return new PrimitiveLongConcatingIterator(primitiveLongIterators.iterator());
    }

    public static PrimitiveLongIterator concat(Iterator<PrimitiveLongIterator> iterators) {
        return new PrimitiveLongConcatingIterator(iterators);
    }

    public static PrimitiveLongIterator prepend(final long item, final PrimitiveLongIterator iterator) {
        return new PrimitiveLongBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return iterator.hasNext() && this.next(iterator.next());
            }
        };
    }

    public static PrimitiveLongIterator append(final PrimitiveLongIterator iterator, final long item) {
        return new PrimitiveLongBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    return this.next(iterator.next());
                }
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return false;
            }
        };
    }

    public static PrimitiveLongIterator filter(PrimitiveLongIterator source, final LongPredicate filter) {
        return new PrimitiveLongFilteringIterator(source){

            @Override
            public boolean test(long item) {
                return filter.test(item);
            }
        };
    }

    public static PrimitiveLongIterator deduplicate(PrimitiveLongIterator source) {
        return new PrimitiveLongFilteringIterator(source){
            private final PrimitiveLongSet visited = Primitive.longSet();

            @Override
            public boolean test(long testItem) {
                return this.visited.add(testItem);
            }
        };
    }

    public static PrimitiveLongIterator not(PrimitiveLongIterator source, final long disallowedValue) {
        return new PrimitiveLongFilteringIterator(source){

            @Override
            public boolean test(long testItem) {
                return testItem != disallowedValue;
            }
        };
    }

    public static PrimitiveLongIterator skip(PrimitiveLongIterator source, final int skipTheFirstNItems) {
        return new PrimitiveLongFilteringIterator(source){
            private int skipped;

            @Override
            public boolean test(long item) {
                if (this.skipped < skipTheFirstNItems) {
                    ++this.skipped;
                    return false;
                }
                return true;
            }
        };
    }

    public static PrimitiveLongIterator limit(final PrimitiveLongIterator source, final int maxItems) {
        return new PrimitiveLongBaseIterator(){
            private int visited;

            @Override
            protected boolean fetchNext() {
                if (this.visited++ < maxItems && source.hasNext()) {
                    return this.next(source.next());
                }
                return false;
            }
        };
    }

    public static PrimitiveLongIterator range(long end) {
        return PrimitiveLongCollections.range(0L, end);
    }

    public static PrimitiveLongIterator range(long start, long end) {
        return PrimitiveLongCollections.range(start, end, 1L);
    }

    public static PrimitiveLongIterator range(long start, long end, long stride) {
        return new PrimitiveLongRangeIterator(start, end, stride);
    }

    public static PrimitiveLongIterator singleton(final long item) {
        return new PrimitiveLongBaseIterator(){
            private boolean returned;

            @Override
            protected boolean fetchNext() {
                try {
                    boolean bl = !this.returned && this.next(item);
                    return bl;
                }
                finally {
                    this.returned = true;
                }
            }
        };
    }

    public static long first(PrimitiveLongIterator iterator) {
        PrimitiveLongCollections.assertMoreItems(iterator);
        return iterator.next();
    }

    private static void assertMoreItems(PrimitiveLongIterator iterator) {
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("No element in " + iterator);
        }
    }

    public static long first(PrimitiveLongIterator iterator, long defaultItem) {
        return iterator.hasNext() ? iterator.next() : defaultItem;
    }

    public static long last(PrimitiveLongIterator iterator) {
        PrimitiveLongCollections.assertMoreItems(iterator);
        return PrimitiveLongCollections.last(iterator, 0L);
    }

    public static long last(PrimitiveLongIterator iterator, long defaultItem) {
        long result = defaultItem;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static long single(PrimitiveLongIterator iterator) {
        try {
            PrimitiveLongCollections.assertMoreItems(iterator);
            long item = iterator.next();
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator + ", first:" + item + ", second:" + iterator.next());
            }
            PrimitiveCommons.closeSafely(iterator);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator, exception);
            throw exception;
        }
    }

    public static long single(PrimitiveLongIterator iterator, long defaultItem) {
        try {
            if (!iterator.hasNext()) {
                PrimitiveCommons.closeSafely(iterator);
                return defaultItem;
            }
            long item = iterator.next();
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator + ", first:" + item + ", second:" + iterator.next());
            }
            PrimitiveCommons.closeSafely(iterator);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator, exception);
            throw exception;
        }
    }

    public static long itemAt(PrimitiveLongIterator iterator, int index) {
        if (index >= 0) {
            for (int i = 0; iterator.hasNext() && i < index; ++i) {
                iterator.next();
            }
            PrimitiveLongCollections.assertMoreItems(iterator);
            return iterator.next();
        }
        int fromEnd = index * -1;
        long[] trail = new long[fromEnd];
        int cursor = 0;
        while (iterator.hasNext()) {
            trail[cursor % trail.length] = iterator.next();
            ++cursor;
        }
        if (cursor < fromEnd) {
            throw new NoSuchElementException("Item " + index + " not found in " + iterator);
        }
        return trail[cursor % fromEnd];
    }

    public static long itemAt(PrimitiveLongIterator iterator, int index, long defaultItem) {
        if (index >= 0) {
            for (int i = 0; iterator.hasNext() && i < index; ++i) {
                iterator.next();
            }
            return iterator.hasNext() ? iterator.next() : defaultItem;
        }
        int fromEnd = index * -1;
        long[] trail = new long[fromEnd];
        int cursor = 0;
        while (iterator.hasNext()) {
            trail[cursor % trail.length] = iterator.next();
            ++cursor;
        }
        return cursor < fromEnd ? defaultItem : trail[cursor % fromEnd];
    }

    public static int indexOf(PrimitiveLongIterator iterator, long item) {
        int i = 0;
        while (iterator.hasNext()) {
            if (item == iterator.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean equals(PrimitiveLongIterator first, PrimitiveLongIterator other) {
        boolean otherHasNext;
        boolean firstHasNext;
        while ((firstHasNext = first.hasNext()) | (otherHasNext = other.hasNext())) {
            if (firstHasNext == otherHasNext && first.next() == other.next()) continue;
            return false;
        }
        return true;
    }

    public static PrimitiveLongSet asSet(PrimitiveLongIterator iterator) {
        PrimitiveLongSet set = Primitive.longSet();
        while (iterator.hasNext()) {
            long next = iterator.next();
            if (set.add(next)) continue;
            throw new IllegalStateException("Duplicate " + next + " from " + iterator);
        }
        return set;
    }

    public static PrimitiveLongSet asSetAllowDuplicates(PrimitiveLongIterator iterator) {
        PrimitiveLongSet set = Primitive.longSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static int count(PrimitiveLongIterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static long[] asArray(PrimitiveLongIterator iterator) {
        long[] array = new long[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static long[] asArray(Iterator<Long> iterator) {
        long[] array = new long[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static PrimitiveLongIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveLongIterator toPrimitiveIterator(final Iterator<Long> iterator) {
        return new PrimitiveLongBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    Long nextValue = (Long)iterator.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Long to primitive long");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static PrimitiveLongSet emptySet() {
        return Empty.EMPTY_PRIMITIVE_LONG_SET;
    }

    public static PrimitiveLongSet setOf(long ... values) {
        Objects.requireNonNull(values, "Values array is null");
        PrimitiveLongSet set = Primitive.longSet(values.length);
        for (long value : values) {
            set.add(value);
        }
        return set;
    }

    public static <T> Iterator<T> map(final LongFunction<T> mapFunction, final PrimitiveLongIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveLongIterator constant(final long value) {
        return new PrimitiveLongBaseIterator(){

            @Override
            protected boolean fetchNext() {
                return this.next(value);
            }
        };
    }

    public static <T> PrimitiveLongObjectMap<T> emptyObjectMap() {
        return Empty.EMPTY_PRIMITIVE_LONG_OBJECT_MAP;
    }

    public static <C extends Collection<Long>> C addToCollection(PrimitiveLongIterator iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static List<Long> asList(PrimitiveLongIterator iterator) {
        ArrayList<Long> out = new ArrayList<Long>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static Iterator<Long> toIterator(final PrimitiveLongIterator primIterator) {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return primIterator.hasNext();
            }

            @Override
            public Long next() {
                return primIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveLongResourceIterator resourceIterator(final PrimitiveLongIterator iterator, final Resource resource) {
        return new PrimitiveLongResourceIterator(){

            public void close() {
                if (resource != null) {
                    resource.close();
                }
            }

            @Override
            public long next() {
                return iterator.next();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static Set<Long> toSet(PrimitiveLongIterator iterator) {
        HashSet<Long> set = new HashSet<Long>();
        while (iterator.hasNext()) {
            PrimitiveLongCollections.addUnique(set, iterator.next());
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static long[] deduplicate(long[] values) {
        int unique = 0;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            for (int j = 0; j < unique; ++j) {
                if (value != values[j]) continue;
                value = -1L;
                break;
            }
            if (value == -1L) continue;
            values[unique++] = values[i];
        }
        return unique < values.length ? Arrays.copyOf(values, unique) : values;
    }

    public static class PrimitiveLongRangeIterator
    extends PrimitiveLongBaseIterator {
        private long current;
        private final long end;
        private final long stride;

        public PrimitiveLongRangeIterator(long start, long end, long stride) {
            this.current = start;
            this.end = end;
            this.stride = stride;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end && this.next(this.current);
                return bl;
            }
            finally {
                this.current += this.stride;
            }
        }
    }

    public static abstract class PrimitiveLongFilteringIterator
    extends PrimitiveLongBaseIterator
    implements LongPredicate {
        private final PrimitiveLongIterator source;

        public PrimitiveLongFilteringIterator(PrimitiveLongIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                long testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(long var1);
    }

    public static class PrimitiveLongInterleavingIterator
    extends PrimitiveLongBaseIterator {
        private final Iterable<PrimitiveLongIterator> iterators;
        private Iterator<PrimitiveLongIterator> currentRound;

        public PrimitiveLongInterleavingIterator(Iterable<PrimitiveLongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentRound == null || !this.currentRound.hasNext()) {
                this.currentRound = this.iterators.iterator();
            }
            while (this.currentRound.hasNext()) {
                PrimitiveLongIterator iterator = this.currentRound.next();
                if (!iterator.hasNext()) continue;
                return this.next(iterator.next());
            }
            this.currentRound = null;
            return false;
        }
    }

    public static class PrimitiveLongConcatingIterator
    extends PrimitiveLongBaseIterator {
        private final Iterator<? extends PrimitiveLongIterator> iterators;
        private PrimitiveLongIterator currentIterator;

        public PrimitiveLongConcatingIterator(Iterator<? extends PrimitiveLongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() && this.next(this.currentIterator.next());
        }

        protected final PrimitiveLongIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveLongBaseIterator
    implements PrimitiveLongIterator {
        private boolean hasNextDecided;
        private boolean hasNext;
        protected long next;

        @Override
        public boolean hasNext() {
            if (!this.hasNextDecided) {
                this.hasNext = this.fetchNext();
                this.hasNextDecided = true;
            }
            return this.hasNext;
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(long nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

