/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntVisitor;

public class PrimitiveIntStack
implements PrimitiveIntCollection {
    private int[] array;
    private int cursor = -1;

    public PrimitiveIntStack() {
        this(16);
    }

    public PrimitiveIntStack(int initialSize) {
        this.array = new int[initialSize];
    }

    @Override
    public boolean isEmpty() {
        return this.cursor == -1;
    }

    @Override
    public void clear() {
        this.cursor = -1;
    }

    @Override
    public int size() {
        return this.cursor + 1;
    }

    @Override
    public void close() {
    }

    @Override
    public PrimitiveIntIterator iterator() {
        return new PrimitiveIntIterator(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx <= PrimitiveIntStack.this.cursor;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PrimitiveIntStack.this.array[this.idx++];
            }
        };
    }

    public void visitKeys(PrimitiveIntVisitor visitor) {
        throw new UnsupportedOperationException("Please implement");
    }

    public void push(int value) {
        this.ensureCapacity();
        this.array[++this.cursor] = value;
    }

    private void ensureCapacity() {
        if (this.cursor == this.array.length - 1) {
            this.array = Arrays.copyOf(this.array, this.array.length << 1);
        }
    }

    public int poll() {
        return this.cursor == -1 ? -1 : this.array[this.cursor--];
    }
}

