/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum EmbeddedBasedParameterConversion implements ParameterConversion
{
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(EmbeddedBasedParameterConversion.class);
    private final ParameterConversion fallback = AbstractConfigurableDriver.CONVERT_ALL_PARAMETERS_CONVERSION;
    private Predicate<Object> canConvert;

    private EmbeddedBasedParameterConversion() {
        try {
            String fqnOfValues = "org.neo4j.values.storable.Values";
            Method unsafeOf = Class.forName(fqnOfValues).getDeclaredMethod("unsafeOf", Object.class, Boolean.TYPE);
            this.canConvert = new WrappedValuesUnsafeOf(unsafeOf);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            this.logger.warn("Cannot use native type conversion prior to Neo4j 3.3.x");
            this.canConvert = anyObject -> false;
        }
    }

    public Map<String, Object> convertParameters(Map<String, Object> originalParameter) {
        HashMap<String, Object> convertedParameter = new HashMap<String, Object>(originalParameter.size());
        HashMap unconvertedParameter = new HashMap(originalParameter.size());
        originalParameter.forEach((parameterKey, unconvertedValue) -> {
            if (unconvertedValue == null) {
                convertedParameter.put((String)parameterKey, null);
            } else if (unconvertedValue instanceof List) {
                convertedParameter.put((String)parameterKey, this.convertListItems((List)unconvertedValue));
            } else if (unconvertedValue.getClass().isArray()) {
                convertedParameter.put((String)parameterKey, this.convertArrayItems(unconvertedValue));
            } else if (unconvertedValue instanceof Map) {
                convertedParameter.put((String)parameterKey, this.convertParameters((Map)unconvertedValue));
            } else if (this.canConvert.test(unconvertedValue)) {
                convertedParameter.put((String)parameterKey, unconvertedValue);
            } else {
                unconvertedParameter.put(parameterKey, unconvertedValue);
            }
        });
        convertedParameter.putAll(this.fallback.convertParameters(unconvertedParameter));
        return convertedParameter;
    }

    private List<?> convertListItems(List<?> unconvertedValues) {
        return unconvertedValues.stream().map(this::convertSingle).collect(Collectors.toList());
    }

    private Object[] convertArrayItems(Object unconvertedValues) {
        int length = Array.getLength(unconvertedValues);
        Object[] convertedValues = new Object[length];
        for (int i = 0; i < length; ++i) {
            convertedValues[i] = this.convertSingle(Array.get(unconvertedValues, i));
        }
        return convertedValues;
    }

    private Object convertSingle(Object value) {
        Predicate<Class> isSupportedNativeCollection = c -> List.class.isAssignableFrom((Class<?>)c) || Map.class.isAssignableFrom((Class<?>)c);
        if (isSupportedNativeCollection.negate().test(value.getClass()) && this.canConvert.test(value)) {
            return value;
        }
        String fixedKey = "u";
        return this.convertParameters(Collections.singletonMap(fixedKey, value)).get(fixedKey);
    }

    private static class WrappedValuesUnsafeOf
    implements Predicate<Object> {
        private final Method unsafeOf;

        WrappedValuesUnsafeOf(Method unsafeOf) {
            this.unsafeOf = unsafeOf;
        }

        @Override
        public boolean test(Object o) {
            try {
                return this.unsafeOf.invoke(null, o, true) != null;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return false;
            }
        }
    }
}

