/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.MatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.IdCollectionMatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.IdMatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.LabelMatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.PathNodeLoadClauseBuilder;

public class NodeQueryStatements<ID extends Serializable>
implements QueryStatements<ID> {
    public static final String PROPERTY_SEPARATOR = "4f392f2f-24b6-4f83-a474-b942a77cd01a";
    private final String primaryIndex;
    private final MatchClauseBuilder idMatchClauseBuilder = new IdMatchClauseBuilder();
    private final MatchClauseBuilder idCollectionMatchClauseBuilder = new IdCollectionMatchClauseBuilder();
    private final MatchClauseBuilder labelMatchClauseBuilder = new LabelMatchClauseBuilder();
    private final LoadClauseBuilder loadClauseBuilder;

    public static String joinPrimaryIndexAttributesIfNecessary(String defaultPrimaryIndex, Object id) {
        String primaryIndexToUse = defaultPrimaryIndex;
        if (id != null && id instanceof Map) {
            primaryIndexToUse = ((Map)id).keySet().stream().collect(Collectors.joining(PROPERTY_SEPARATOR));
        }
        return primaryIndexToUse;
    }

    public static String splitPrimaryIndexAttributes(String property) {
        if (property.contains(PROPERTY_SEPARATOR)) {
            return Arrays.stream(property.split(PROPERTY_SEPARATOR)).map(p -> "`" + p + "`: n.`" + p + "`").collect(Collectors.joining(",", "{", "}"));
        }
        return "n.`" + property + "`";
    }

    public NodeQueryStatements() {
        this(null, new PathNodeLoadClauseBuilder());
    }

    public NodeQueryStatements(String primaryIndex, LoadClauseBuilder loadClauseBuilder) {
        this.primaryIndex = primaryIndex;
        this.loadClauseBuilder = Objects.requireNonNull(loadClauseBuilder);
    }

    @Override
    public PagingAndSortingQuery findOne(ID id, int depth) {
        return this.findOneByType("", id, depth);
    }

    @Override
    public PagingAndSortingQuery findOneByType(String label, ID id, int depth) {
        String primaryIndexToUse = NodeQueryStatements.joinPrimaryIndexAttributesIfNecessary(this.primaryIndex, id);
        String matchClause = this.primaryIndex != null ? this.idMatchClauseBuilder.build(label, primaryIndexToUse) : this.idMatchClauseBuilder.build(label);
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, Collections.singletonMap("id", id), depth != 0, false);
    }

    @Override
    public PagingAndSortingQuery findAllByType(String label, Collection<ID> ids, int depth) {
        String primaryIndexToUse = NodeQueryStatements.joinPrimaryIndexAttributesIfNecessary(this.primaryIndex, ids.isEmpty() ? null : ids.iterator().next());
        String matchClause = this.primaryIndex != null ? this.idCollectionMatchClauseBuilder.build(label, primaryIndexToUse) : this.idCollectionMatchClauseBuilder.build(label);
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, Collections.singletonMap("ids", ids), depth != 0, false);
    }

    @Override
    public PagingAndSortingQuery findByType(String label, int depth) {
        String matchClause = this.labelMatchClauseBuilder.build(label);
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, Collections.emptyMap(), depth != 0, false);
    }

    @Override
    public PagingAndSortingQuery findByType(String label, Filters parameters, int depth) {
        FilteredQuery filteredQuery = FilteredQueryBuilder.buildNodeQuery(label, parameters);
        String matchClause = filteredQuery.statement();
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, filteredQuery.parameters(), depth != 0, true);
    }
}

