/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class PropertyComparison
implements FilterFunction<Object> {
    private Object value;
    private Filter filter;

    public PropertyComparison(Object value) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String expression(String nodeIdentifier) {
        if (this.filter.getComparisonOperator().equals((Object)ComparisonOperator.IS_NULL)) {
            return String.format("%s.`%s` IS NULL ", nodeIdentifier, this.filter.getPropertyName());
        }
        if (this.filter.getComparisonOperator().equals((Object)ComparisonOperator.EXISTS)) {
            return String.format("EXISTS(%s.`%s`) ", nodeIdentifier, this.filter.getPropertyName());
        }
        if (this.filter.getComparisonOperator().equals((Object)ComparisonOperator.IS_TRUE)) {
            return String.format("%s.`%s` = true ", nodeIdentifier, this.filter.getPropertyName());
        }
        return String.format("%s.`%s` %s $`%s` ", nodeIdentifier, this.filter.getPropertyName(), this.filter.getComparisonOperator().getValue(), this.filter.uniqueParameterName());
    }

    @Override
    public Map<String, Object> parameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.filter.getComparisonOperator().isOneOf(ComparisonOperator.IS_NULL, ComparisonOperator.EXISTS, ComparisonOperator.IS_TRUE)) {
            map.put(this.filter.uniqueParameterName(), this.filter.getTransformedPropertyValue());
        }
        return map;
    }
}

