/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.FilterWithRelationship;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.NoOpPropertyValueTransformer;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.PropertyComparison;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class Filter
implements FilterWithRelationship {
    private int index = 0;
    private String propertyName;
    private ComparisonOperator comparisonOperator;
    private BooleanOperator booleanOperator = BooleanOperator.NONE;
    private boolean negated;
    private Class<?> ownerEntityType;
    private String nestedEntityTypeLabel;
    private String nestedPropertyName;
    private Class<?> nestedPropertyType;
    private String relationshipType;
    private String relationshipDirection;
    private AttributeConverter propertyConverter;
    private CompositeAttributeConverter compositeConverter;
    private boolean nestedRelationshipEntity;
    private FilterFunction function;
    private List<NestedPathSegment> nestedPath;

    public Filter(FilterFunction function) {
        this(null, function, null);
    }

    public Filter(String propertyName, FilterFunction filterFunction) {
        this(propertyName, filterFunction, null);
    }

    public Filter(DistanceComparison distanceComparisonFunction, ComparisonOperator comparisonOperator) {
        this(null, distanceComparisonFunction, comparisonOperator);
    }

    public Filter(String propertyName, ComparisonOperator comparisonOperator, Object propertyValue) {
        this(propertyName, new PropertyComparison(propertyValue), comparisonOperator);
    }

    @Deprecated
    public Filter(String propertyName, FilterFunction filterFunction, ComparisonOperator comparisonOperator) {
        this.propertyName = propertyName;
        this.function = filterFunction;
        this.function.setFilter(this);
        this.comparisonOperator = comparisonOperator;
    }

    public Filter(String propertyName, ComparisonOperator comparisonOperator) {
        this(new PropertyComparison(null));
        this.propertyName = propertyName;
        if (!EnumSet.of(ComparisonOperator.EXISTS, ComparisonOperator.IS_TRUE, ComparisonOperator.IS_NULL).contains((Object)comparisonOperator)) {
            throw new RuntimeException("This constructor can only be used with Unary comparison operators");
        }
        this.comparisonOperator = comparisonOperator;
    }

    public static void setNameFromProperty(Filter filter, String propertyName) {
        filter.propertyName = propertyName;
    }

    public String getRelationshipDirection() {
        return this.relationshipDirection;
    }

    @Override
    public void setRelationshipDirection(String relationshipDirection) {
        this.relationshipDirection = relationshipDirection;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Deprecated
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Deprecated
    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    public Filters and(Filter filter) {
        filter.setBooleanOperator(BooleanOperator.AND);
        return new Filters(this, filter);
    }

    public Filters or(Filter filter) {
        filter.setBooleanOperator(BooleanOperator.OR);
        return new Filters(this, filter);
    }

    public Filter ignoreCase() {
        if (!(this.function instanceof PropertyComparison)) {
            throw new IllegalStateException("ignoreCase is only supported for a filter based on property comparison");
        }
        if (!this.getComparisonOperator().isOneOf(ComparisonOperator.EQUALS, ComparisonOperator.CONTAINING, ComparisonOperator.STARTING_WITH, ComparisonOperator.ENDING_WITH)) {
            throw new IllegalStateException(String.format("ignoreCase is only supported for %s or %s comparison", ComparisonOperator.EQUALS.name(), ComparisonOperator.CONTAINING.name()));
        }
        this.function = new CaseInsensitiveEqualsComparison((PropertyComparison)this.function);
        return this;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public Class<?> getOwnerEntityType() {
        return this.ownerEntityType;
    }

    public void setOwnerEntityType(Class<?> ownerEntityType) {
        this.ownerEntityType = ownerEntityType;
    }

    public String getNestedPropertyName() {
        return this.nestedPropertyName;
    }

    public void setNestedPropertyName(String nestedPropertyName) {
        this.nestedPropertyName = nestedPropertyName;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Override
    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean isNested() {
        return this.nestedPropertyName != null;
    }

    public Class<?> getNestedPropertyType() {
        return this.nestedPropertyType;
    }

    public void setNestedPropertyType(Class<?> nestedPropertyType) {
        this.nestedPropertyType = nestedPropertyType;
    }

    public String getNestedEntityTypeLabel() {
        return this.nestedEntityTypeLabel;
    }

    public void setNestedEntityTypeLabel(String nestedEntityTypeLabel) {
        this.nestedEntityTypeLabel = nestedEntityTypeLabel;
    }

    public void setNestedPath(NestedPathSegment ... path) {
        this.nestedPath = new ArrayList<NestedPathSegment>(Arrays.asList(path));
    }

    public List<NestedPathSegment> getNestedPath() {
        return this.nestedPath;
    }

    public boolean isDeepNested() {
        return this.getNestedPath() != null && !this.getNestedPath().isEmpty();
    }

    public boolean isNestedRelationshipEntity() {
        return this.nestedRelationshipEntity;
    }

    public void setNestedRelationshipEntity(boolean nestedRelationshipEntity) {
        this.nestedRelationshipEntity = nestedRelationshipEntity;
    }

    @Deprecated
    public String uniqueParameterName() {
        return this.isNested() ? this.getNestedPropertyName() + "_" + this.getPropertyName() + "_" + this.index : this.getPropertyName() + "_" + this.index;
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    @Deprecated
    public void setPropertyConverter(AttributeConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }

    @Deprecated
    public CompositeAttributeConverter getCompositeAttributeConverter() {
        return this.compositeConverter;
    }

    public void setCompositeConverter(CompositeAttributeConverter compositeAttributeConverter) {
        this.compositeConverter = compositeAttributeConverter;
    }

    @Deprecated
    public Object getTransformedPropertyValue() {
        Object value = this.function.getValue();
        if (this.getPropertyConverter() != null) {
            value = this.getPropertyConverter().toGraphProperty(value);
        } else if (this.getCompositeAttributeConverter() != null) {
            throw new MappingException("Properties with a CompositeAttributeConverter are not supported by Filters in this version of OGM. Consider implementing a custom FilterFunction.");
        }
        return this.transformPropertyValue(value);
    }

    private Object transformPropertyValue(Object value) {
        if (this.comparisonOperator != null) {
            return this.comparisonOperator.getPropertyValueTransformer().transformPropertyValue(value);
        }
        return new NoOpPropertyValueTransformer().transformPropertyValue(value);
    }

    public FilterFunction getFunction() {
        return this.function;
    }

    @Deprecated
    public void setFunction(FilterFunction function) {
        assert (function != null);
        this.function = function;
        this.function.setFilter(this);
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String toCypher(String nodeIdentifier, boolean addWhereClause) {
        String fragment = this.function.expression(nodeIdentifier, this.propertyName, s -> this.uniqueParameterName());
        String suffix = this.isNegated() ? this.negate(fragment) : fragment;
        return this.cypherPrefix(addWhereClause) + suffix;
    }

    public Map<String, Object> parameters() {
        return this.function.parameters(s -> this.uniqueParameterName(), this::transformPropertyValue);
    }

    private String cypherPrefix(boolean addWhereClause) {
        StringBuilder cypher = new StringBuilder();
        if (addWhereClause) {
            cypher.append("WHERE ");
        } else if (!this.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
            cypher.append(this.getBooleanOperator().getValue()).append(" ");
        }
        return cypher.toString();
    }

    private String negate(String expression) {
        return String.format("NOT(%s) ", expression);
    }

    static final class CaseInsensitiveEqualsComparison
    extends PropertyComparison {
        private CaseInsensitiveEqualsComparison(PropertyComparison propertyComparison) {
            super(propertyComparison.getValue());
            super.setFilter(propertyComparison.getFilter());
        }

        @Override
        public String expression(String nodeIdentifier) {
            Filter filter = this.getFilter();
            return String.format("toLower(%s.`%s`) %s toLower($`%s`) ", nodeIdentifier, filter.getPropertyName(), filter.getComparisonOperator().getValue(), filter.uniqueParameterName());
        }
    }

    public static class NestedPathSegment
    implements FilterWithRelationship {
        private final String propertyName;
        private final Class propertyType;
        private String relationshipType;
        private String relationshipDirection;
        private String nestedEntityTypeLabel;
        private boolean nestedRelationshipEntity;

        public NestedPathSegment(String propertyName, Class propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public String getRelationshipType() {
            return this.relationshipType;
        }

        @Override
        public void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        public void setRelationshipDirection(String relationshipDirection) {
            this.relationshipDirection = relationshipDirection;
        }

        public String getRelationshipDirection() {
            return this.relationshipDirection;
        }

        public void setNestedEntityTypeLabel(String nestedEntityTypeLabel) {
            this.nestedEntityTypeLabel = nestedEntityTypeLabel;
        }

        public String getNestedEntityTypeLabel() {
            return this.nestedEntityTypeLabel;
        }

        public void setNestedRelationshipEntity(boolean nestedRelationshipEntity) {
            this.nestedRelationshipEntity = nestedRelationshipEntity;
        }

        public boolean isNestedRelationshipEntity() {
            return this.nestedRelationshipEntity;
        }
    }
}

