/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.core.ConfigurationException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.session.LoadStrategy;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactory.class);
    private final MetaData metaData;
    private final Driver driver;
    private final List<EventListener> eventListeners;
    private final boolean useStrictQuerying;
    private LoadStrategy loadStrategy = LoadStrategy.SCHEMA_LOAD_STRATEGY;
    private EntityInstantiator entityInstantiator;
    private BiFunction<Driver, Session, TransactionManager> transactionManagerFactory = DefaultTransactionManager::new;

    public SessionFactory(String ... packages) {
        this(new Configuration.Builder().build(), packages);
    }

    public SessionFactory(Configuration configuration, String ... packages) {
        this(SessionFactory.newConfiguredDriverInstance(configuration), configuration.mergeBasePackagesWith(packages));
        if (configuration.getAutoIndex() != AutoIndexMode.NONE) {
            this.runAutoIndexManager(configuration);
        }
    }

    public SessionFactory(Driver driver, String ... packages) {
        this(driver, Optional.ofNullable(driver.getConfiguration()).map(Configuration::getUseStrictQuerying).orElse(true), packages);
    }

    public SessionFactory(Driver driver, boolean useStrictQuerying, String ... packages) {
        this.metaData = new MetaData(driver.getTypeSystem(), packages);
        this.driver = driver;
        this.useStrictQuerying = useStrictQuerying;
        this.eventListeners = new CopyOnWriteArrayList<EventListener>();
        this.entityInstantiator = new ReflectionEntityInstantiator(this.metaData);
    }

    public final void runAutoIndexManager(Configuration configuration) {
        LOGGER.warn("The auto index manager is not supported in Neo4j-OGM 4+. No indexes will get created.");
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public Session openSession() {
        return new Neo4jSession(this.metaData, this.useStrictQuerying, this.driver, this.eventListeners, this.loadStrategy, this.entityInstantiator, this.transactionManagerFactory);
    }

    public void register(EventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public void deregister(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
    }

    public boolean isUseStrictQuerying() {
        return this.useStrictQuerying;
    }

    public void setEntityInstantiator(EntityInstantiator entityInstantiator) {
        this.entityInstantiator = entityInstantiator;
    }

    public void setTransactionManagerFactory(BiFunction<Driver, Session, TransactionManager> transactionManagerFactory) {
        this.transactionManagerFactory = Objects.requireNonNull(transactionManagerFactory, "Transaction manager factory is required.");
    }

    public void close() {
        this.driver.close();
    }

    public void register(IdStrategy strategy) {
        Objects.requireNonNull(strategy);
        for (ClassInfo classInfo : this.metaData.persistentEntities()) {
            if (!strategy.getClass().equals(classInfo.idStrategyClass())) continue;
            classInfo.registerIdGenerationStrategy(strategy);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrappedInstance = clazz.isInstance(this.driver) ? clazz.cast(this.driver) : this.driver.unwrap(clazz);
        return unwrappedInstance;
    }

    private static Driver newConfiguredDriverInstance(Configuration configuration) {
        String driverClassName = configuration.getDriverClassName();
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            Driver driver = (Driver)driverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            driver.configure(configuration);
            return driver;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("Could not load driver class " + driverClassName, e);
        }
    }
}

