/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;

public class EntityUtils {
    private static AtomicLong idSequence = new AtomicLong(0L);

    public static Long nextRef() {
        return idSequence.decrementAndGet();
    }

    public static Long identity(Object entity, MetaData metaData) {
        ClassInfo classInfo = metaData.classInfo(entity);
        FieldInfo identityField = classInfo.identityField();
        Object id = identityField.readProperty(entity);
        if (id == null) {
            Long generated = idSequence.decrementAndGet();
            identityField.write(entity, generated);
            return generated;
        }
        return (Long)id;
    }

    public static void setIdentity(Object entity, Long identity, MetaData metaData) {
        ClassInfo classInfo = metaData.classInfo(entity);
        if (classInfo.hasIdentityField()) {
            FieldInfo identityField = classInfo.identityField();
            identityField.write(entity, identity);
        } else if (identity == null) {
            classInfo.fieldsInfo().fields().stream().filter(f -> f.getAnnotations().has(Id.class) && f.getAnnotations().has(GeneratedValue.class)).findFirst().ifPresent(generatedField -> generatedField.write(entity, null));
        }
    }

    public static Collection<String> labels(Object entity, MetaData metaData) {
        Collection dynamicLabels;
        ClassInfo classInfo = metaData.classInfo(entity);
        ArrayList<String> labels = new ArrayList<String>(classInfo.staticLabels());
        FieldInfo labelFieldInfo = classInfo.labelFieldOrNull();
        if (labelFieldInfo != null && (dynamicLabels = (Collection)labelFieldInfo.readProperty(entity)) != null) {
            labels.addAll(dynamicLabels);
        }
        return labels;
    }
}

