/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class LocalDateStringConverter
implements AttributeConverter<LocalDate, String> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;

    @Override
    public String toGraphProperty(LocalDate value) {
        if (value == null) {
            return null;
        }
        return this.formatter.format(value);
    }

    @Override
    public LocalDate toEntityAttribute(String value) {
        if (value == null) {
            return null;
        }
        return this.formatter.parse((CharSequence)value, LocalDate::from);
    }
}

