/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.Base64;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class ByteArrayWrapperBase64Converter
implements AttributeConverter<Byte[], String> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    @Override
    public String toGraphProperty(Byte[] value) {
        if (value == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(ByteArrayWrapperBase64Converter.toPrimitive(value));
    }

    private static byte[] toPrimitive(Byte[] array) {
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Override
    public Byte[] toEntityAttribute(String value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(value);
        Byte[] wrapper = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            wrapper[i] = bytes[i];
        }
        return wrapper;
    }
}

