/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.ogm.config.Configuration;

public final class DescriptorMappings {
    private static final Map<String, Class<?>> DESCRIPTORS_OF_PRIMITIVES = Arrays.asList(Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE).stream().collect(Collectors.collectingAndThen(Collectors.toMap(Class::getName, Function.identity()), Collections::unmodifiableMap));
    private static final Map<String, Class<?>> DESCRIPTORS_OF_WRAPPERS = Arrays.asList(Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Object.class, String.class).stream().collect(Collectors.collectingAndThen(Collectors.toMap(Class::getName, Function.identity()), Collections::unmodifiableMap));
    private static Map<String, Optional<Class<?>>> descriptorsToTypeMappingCache = new ConcurrentHashMap();

    static boolean describesPrimitve(String descriptor) {
        return DESCRIPTORS_OF_PRIMITIVES.containsKey(DescriptorMappings.stripArraySuffix(descriptor));
    }

    static boolean describesWrapper(String descriptor) {
        return DESCRIPTORS_OF_WRAPPERS.containsKey(DescriptorMappings.stripArraySuffix(descriptor));
    }

    public static Class<?> getType(String descriptor) {
        Optional<Class<?>> optionalType = descriptorsToTypeMappingCache.computeIfAbsent(descriptor, k -> Optional.ofNullable(DescriptorMappings.computeType(descriptor)));
        boolean needsRecomputation = optionalType.map(type -> type.getClassLoader() != null && !DescriptorMappings.isLoadedInSameHierarchy(type)).orElse(false);
        if (needsRecomputation) {
            optionalType = Optional.ofNullable(DescriptorMappings.computeType(descriptor));
            descriptorsToTypeMappingCache.put(descriptor, optionalType);
        }
        return optionalType.orElse(null);
    }

    static boolean isLoadedInSameHierarchy(Class<?> type) {
        ClassLoader classLoader = type.getClassLoader();
        for (ClassLoader currentClassLoader = Configuration.getDefaultClassLoader(); currentClassLoader != null; currentClassLoader = currentClassLoader.getParent()) {
            if (classLoader != currentClassLoader) continue;
            return true;
        }
        return false;
    }

    private static Class<?> computeType(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        String rawDescriptor = DescriptorMappings.stripArraySuffix(descriptor);
        if (DESCRIPTORS_OF_WRAPPERS.containsKey(rawDescriptor)) {
            return DESCRIPTORS_OF_WRAPPERS.get(rawDescriptor);
        }
        if (DESCRIPTORS_OF_PRIMITIVES.containsKey(rawDescriptor)) {
            return DESCRIPTORS_OF_PRIMITIVES.get(rawDescriptor);
        }
        if (!rawDescriptor.contains(".") && !rawDescriptor.contains("$")) {
            return Object.class;
        }
        try {
            return Class.forName(rawDescriptor, true, Configuration.getDefaultClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static String stripArraySuffix(String descriptor) {
        return descriptor.replaceAll("(\\[\\])+$", "");
    }

    private DescriptorMappings() {
    }
}

