/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.exception.core;

import org.neo4j.ogm.exception.core.MappingException;

public final class InvalidRelationshipTargetException
extends MappingException {
    private final Class<?> startNodeType;
    private final String relationshipType;
    private final String attributeName;
    private final Class<?> endNodeType;

    public InvalidRelationshipTargetException(Class<?> startNodeType, String relationshipType, String attributeName, Class<?> endNodeType) {
        super("The relationship '" + relationshipType + "' from '" + startNodeType.getName() + "' to '" + endNodeType.getName() + "' stored on '#" + attributeName + "' contains 'null', which is an invalid target for this relationship.'");
        this.startNodeType = startNodeType;
        this.relationshipType = relationshipType;
        this.attributeName = attributeName;
        this.endNodeType = endNodeType;
    }

    public Class<?> getStartNodeType() {
        return this.startNodeType;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Class<?> getEndNodeType() {
        return this.endNodeType;
    }
}

